/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.cmd.AbstractExternalWorkerJobCmd;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;

public class ExternalWorkerJobFailCmd
extends AbstractExternalWorkerJobCmd {
    protected int retries;
    protected Duration retryTimeout;
    protected String errorMessage;
    protected String errorDetails;

    public ExternalWorkerJobFailCmd(String externalJobId, String workerId, int retries, Duration retryTimeout, String errorMessage, String errorDetails, JobServiceConfiguration jobServiceConfiguration) {
        super(externalJobId, workerId, jobServiceConfiguration);
        this.retries = retries;
        this.retryTimeout = retryTimeout;
        this.errorMessage = errorMessage;
        this.errorDetails = errorDetails;
    }

    @Override
    protected void runJobLogic(ExternalWorkerJobEntity externalWorkerJob, CommandContext commandContext) {
        externalWorkerJob.setExceptionMessage(this.errorMessage);
        externalWorkerJob.setExceptionStacktrace(this.errorDetails);
        int newRetries = this.retries >= 0 ? this.retries : externalWorkerJob.getRetries() - 1;
        if (newRetries > 0) {
            externalWorkerJob.setRetries(newRetries);
            externalWorkerJob.setLockOwner(null);
            if (this.retryTimeout == null) {
                externalWorkerJob.setLockExpirationTime(null);
            } else {
                Instant lockExpirationTime = this.jobServiceConfiguration.getClock().getCurrentTime().toInstant().plusMillis(this.retryTimeout.toMillis());
                externalWorkerJob.setLockExpirationTime(Date.from(lockExpirationTime));
            }
        } else {
            this.jobServiceConfiguration.getJobService().moveJobToDeadLetterJob(externalWorkerJob);
        }
    }
}

