/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTimerToExecutableJobCmd
implements Command<JobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveTimerToExecutableJobCmd.class);
    protected String jobId;
    protected JobServiceConfiguration jobServiceConfiguration;

    public MoveTimerToExecutableJobCmd(String jobId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public JobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        TimerJobEntity timerJob = (TimerJobEntity)this.jobServiceConfiguration.getTimerJobEntityManager().findById(this.jobId);
        if (timerJob == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing timer job {}", (Object)timerJob.getId());
        }
        return this.jobServiceConfiguration.getJobManager().moveTimerJobToExecutableJob(timerJob);
    }

    public String getJobId() {
        return this.jobId;
    }
}

