/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BootstrapCheckbox
extends FormComponentPanel<Boolean> {
    private static final long serialVersionUID = 1L;
    private WebMarkupContainer wrapper;
    private boolean inline = false;
    private CheckBox checkbox;
    private final IModel<?> labelModel;

    public BootstrapCheckbox(String id) {
        this(id, null);
    }

    public BootstrapCheckbox(String id, IModel<Boolean> model) {
        this(id, model, null);
    }

    public BootstrapCheckbox(String id, IModel<Boolean> model, IModel<?> labelModel) {
        super(id, model);
        this.labelModel = labelModel;
        this.setType(Boolean.class);
        this.setRenderBodyOnly(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.getWrapper().add(new Component[]{this.newLabel("label", this.labelModel).add(new Behavior[]{new AttributeModifier("for", (IModel)new Model<String>(){

            public String getObject() {
                return BootstrapCheckbox.this.getCheckbox().getMarkupId(true);
            }
        })})}).add(new Component[]{this.getCheckbox()})});
    }

    private WebMarkupContainer getWrapper() {
        if (this.wrapper == null) {
            this.wrapper = this.newCheckboxContainer("wrapper");
        }
        return this.wrapper;
    }

    private CheckBox getCheckbox() {
        if (this.checkbox == null) {
            this.checkbox = this.newCheckBox("checkbox", (IModel<Boolean>)this.getModel());
            this.checkbox.setOutputMarkupId(true);
        }
        return this.checkbox;
    }

    protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
        return new CheckBox(id, model);
    }

    protected Component newLabel(String id, IModel<?> labelModel) {
        return new Label(id, labelModel){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                IModel model = this.getDefaultModel();
                this.setVisible(model != null && model.getObject() != null);
            }
        };
    }

    protected WebMarkupContainer newCheckboxContainer(String id) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (BootstrapCheckbox.this.isInline()) {
                    Attributes.addClass(tag, "form-check-inline");
                }
            }
        };
    }

    public boolean isInline() {
        return this.inline;
    }

    public BootstrapCheckbox setInline(boolean inline) {
        this.inline = inline;
        return this;
    }

    public BootstrapCheckbox setLabel(IModel<String> label) {
        this.getCheckbox().setLabel(label);
        return this;
    }

    public IModel<String> getLabel() {
        return this.getCheckbox().getLabel();
    }

    public void convertInput() {
        this.setConvertedInput((Boolean)this.getCheckbox().getConvertedInput());
    }

    protected void detachModel() {
        super.detachModel();
        if (this.labelModel != null) {
            this.labelModel.detach();
        }
    }
}

