/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public final class OAuth20Utils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20Utils.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleArrayElementUnwrapped(true).build().toObjectMapper();

    public static ModelAndView writeError(HttpServletResponse response, String error) {
        return OAuth20Utils.writeError(response, error, null);
    }

    public static ModelAndView writeError(HttpServletResponse response, String error, String description) {
        Map<String, Object> model = OAuth20Utils.getErrorResponseBody(error, description);
        ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
        mv.setStatus(HttpStatus.BAD_REQUEST);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return mv;
    }

    public static Map<String, Object> getErrorResponseBody(String error, String description) {
        Map model = CollectionUtils.wrap((String)"error", (Object)error);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            model.put("error_description", description);
        }
        return model;
    }

    public static OAuthRegisteredService getRegisteredOAuthServiceByClientId(ServicesManager servicesManager, String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return null;
        }
        return OAuth20Utils.getRegisteredOAuthServiceByPredicate(servicesManager, s -> s.getClientId().equalsIgnoreCase(clientId));
    }

    public static OAuthRegisteredService getRegisteredOAuthServiceByRedirectUri(ServicesManager servicesManager, String redirectUri) {
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            return null;
        }
        return OAuth20Utils.getRegisteredOAuthServiceByPredicate(servicesManager, s -> s.matches(redirectUri));
    }

    private static OAuthRegisteredService getRegisteredOAuthServiceByPredicate(ServicesManager servicesManager, Predicate<OAuthRegisteredService> predicate) {
        Collection services = servicesManager.getAllServicesOfType(OAuthRegisteredService.class);
        return services.stream().filter(predicate).findFirst().orElse(null);
    }

    public static ModelAndView produceUnauthorizedErrorView() {
        return OAuth20Utils.produceUnauthorizedErrorView(HttpStatus.UNAUTHORIZED);
    }

    public static ModelAndView produceUnauthorizedErrorView(HttpStatus status) {
        UnauthorizedServiceException ex = new UnauthorizedServiceException("screen.service.error.message", "");
        return OAuth20Utils.produceErrorView((Exception)ex, status);
    }

    public static ModelAndView produceErrorView(Exception e) {
        return OAuth20Utils.produceErrorView(e, HttpStatus.UNAUTHORIZED);
    }

    public static ModelAndView produceErrorView(Exception e, HttpStatus status) {
        ModelAndView mv = new ModelAndView("error/casServiceErrorView", CollectionUtils.wrap((String)"rootCauseException", (Object)e));
        mv.setStatus(status);
        return mv;
    }

    public static String casOAuthCallbackUrl(String serverPrefixUrl) {
        return serverPrefixUrl.concat("/oauth2.0/callbackAuthorize");
    }

    public static String toJson(Object value) {
        return (String)FunctionUtils.doUnchecked(() -> MAPPER.writeValueAsString(value));
    }

    public static boolean isResponseModeTypeFormPost(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseType) {
        return responseType == OAuth20ResponseModeTypes.FORM_POST || registeredService != null && StringUtils.equalsIgnoreCase((CharSequence)"post", (CharSequence)registeredService.getResponseType());
    }

    public static boolean isResponseModeTypeFragment(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseType) {
        return responseType == OAuth20ResponseModeTypes.FRAGMENT || registeredService != null && StringUtils.equalsIgnoreCase((CharSequence)OAuth20ResponseModeTypes.FRAGMENT.getType(), (CharSequence)registeredService.getResponseType());
    }

    public static boolean isGrantType(String type, OAuth20GrantTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }

    public static boolean isResponseType(String type, OAuth20ResponseTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }

    public static boolean isResponseModeType(String type, OAuth20ResponseModeTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }

    public static String getServiceRequestHeaderIfAny(WebContext context) {
        return context.getRequestHeader("service").or(() -> context.getRequestHeader("X-".concat("service"))).orElse("");
    }

    public static boolean checkCallbackValid(@NonNull RegisteredService registeredService, String redirectUri) {
        RegisteredServiceMatchingStrategy matchingStrategy;
        if (registeredService == null) {
            throw new NullPointerException("registeredService is marked non-null but is null");
        }
        RegisteredServiceMatchingStrategy registeredServiceMatchingStrategy = matchingStrategy = registeredService != null ? registeredService.getMatchingStrategy() : null;
        if (matchingStrategy == null || !matchingStrategy.matches(registeredService, redirectUri)) {
            LOGGER.error("Unsupported [{}]: [{}] does not match what is defined for registered service: [{}]. Service is considered unauthorized. Verify the service matching strategy used in the service definition is correct and does in fact match the client [{}]", new Object[]{"redirect_uri", redirectUri, registeredService.getServiceId(), redirectUri});
            return false;
        }
        return true;
    }

    public static boolean checkResponseTypes(String type, OAuth20ResponseTypes ... expectedTypes) {
        LOGGER.debug("Response type: [{}]", (Object)type);
        boolean checked = Stream.of(expectedTypes).anyMatch(t -> OAuth20Utils.isResponseType(type, t));
        if (!checked) {
            LOGGER.error("Unsupported response type: [{}]", (Object)type);
        }
        return checked;
    }

    public static String getClientIdFromAuthenticatedProfile(UserProfile profile) {
        HashMap attrs = new HashMap(profile.getAttributes());
        if (attrs.containsKey("client_id")) {
            Object attribute = attrs.get("client_id");
            return ((ArrayList)CollectionUtils.toCollection(attribute, ArrayList.class)).get(0).toString();
        }
        return null;
    }

    public static Set<String> parseUserInfoRequestClaims(OAuth20Token token) {
        return ((Map)token.getClaims().getOrDefault("userinfo", new HashMap(0))).keySet();
    }

    public static UserProfile getAuthenticatedUserProfile(WebContext context, SessionStore sessionStore) {
        ProfileManager manager = new ProfileManager(context, sessionStore);
        Optional profile = manager.getProfile();
        return (UserProfile)profile.orElseThrow(() -> new IllegalArgumentException("Unable to determine the user profile from the context"));
    }

    public static boolean doesServiceNeedAuthentication(OAuthRegisteredService registeredService) {
        return StringUtils.isNotBlank((CharSequence)registeredService.getClientSecret());
    }

    @Generated
    private OAuth20Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

