/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.url.UrlResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20CasCallbackUrlResolver
implements UrlResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20CasCallbackUrlResolver.class);
    private final String callbackUrl;
    private final OAuth20RequestParameterResolver requestParameterResolver;

    public String compute(String url, WebContext context) {
        if (!url.startsWith(this.callbackUrl)) {
            return url;
        }
        return (String)FunctionUtils.doUnchecked(() -> {
            URIBuilder builder = new URIBuilder(url);
            this.addUrlParameter(context, builder, "client_id");
            this.addUrlParameter(context, builder, "scope");
            this.addUrlParameter(context, builder, "redirect_uri");
            this.addUrlParameter(context, builder, "acr_values");
            this.addUrlParameter(context, builder, "response_type");
            this.addUrlParameter(context, builder, "grant_type");
            this.addUrlParameter(context, builder, "response_mode");
            this.addUrlParameter(context, builder, "claims");
            this.addUrlParameter(context, builder, "request");
            this.addUrlParameter(context, builder, "state");
            this.addUrlParameter(context, builder, "nonce");
            this.getIncludeParameterNames().forEach(param -> this.addUrlParameter(context, builder, (String)param));
            String callbackResolved = builder.build().toString();
            LOGGER.debug("Final resolved callback URL is [{}]", (Object)callbackResolved);
            return callbackResolved;
        });
    }

    protected List<String> getIncludeParameterNames() {
        return new ArrayList<String>(0);
    }

    private Optional<NameValuePair> getQueryParameter(WebContext context, String name) {
        Optional<String> value = this.requestParameterResolver.resolveRequestParameter(context, name).or(Unchecked.supplier(() -> {
            URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
            return builderContext.getQueryParams().stream().filter(p -> p.getName().equalsIgnoreCase(name)).map(NameValuePair::getValue).findFirst();
        }));
        return value.map(v -> new BasicNameValuePair(name, v));
    }

    private void addUrlParameter(WebContext context, URIBuilder builder, String parameterName) {
        Optional<NameValuePair> parameter = this.getQueryParameter(context, parameterName);
        parameter.ifPresent(basicNameValuePair -> builder.addParameter(basicNameValuePair.getName(), basicNameValuePair.getValue()));
    }

    @Generated
    public OAuth20CasCallbackUrlResolver(String callbackUrl, OAuth20RequestParameterResolver requestParameterResolver) {
        this.callbackUrl = callbackUrl;
        this.requestParameterResolver = requestParameterResolver;
    }
}

