/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuth20CodeExpirationPolicyBuilder
implements ExpirationPolicyBuilder<OAuth20Code> {
    private static final long serialVersionUID = -3597980180617072826L;
    protected final CasConfigurationProperties casProperties;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        return new OAuth20CodeExpirationPolicy(oauth.getCode().getNumberOfUses(), oauth.getCode().getTimeToKillInSeconds());
    }

    @Generated
    public OAuth20CodeExpirationPolicyBuilder(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Generated
    public String toString() {
        return "OAuth20CodeExpirationPolicyBuilder(casProperties=" + this.casProperties + ")";
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

