/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.InputStreamSource;

public class X509CertificateCredentialJsonDeserializer
extends JsonDeserializer<X509CertificateCredential> {
    public X509CertificateCredential deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)JsonNode.class.cast(oc.readTree(jp));
        List certificates = node.findValues("certificates");
        ArrayList certs = new ArrayList(certificates.size());
        certificates.forEach(n -> {
            String cert = n.get(0).textValue();
            byte[] data = EncodingUtils.decodeBase64((String)cert);
            certs.add(CertUtils.readCertificate((InputStreamSource)new InputStreamResource((InputStream)new ByteArrayInputStream(data))));
        });
        return new X509CertificateCredential((X509Certificate[])certs.toArray(X509Certificate[]::new));
    }
}

