/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.resources.oidcc4ui;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.common.rest.api.service.OIDCC4UIService;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogoutResource
extends AbstractResource {
    private static final long serialVersionUID = 273797583932923564L;
    protected static final Logger LOG = LoggerFactory.getLogger(LogoutResource.class);

    protected abstract Class<? extends WebPage> getLogoutPageClass();

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
        String logoutToken = Optional.ofNullable(request.getParameter("logout_token")).orElseThrow(() -> new RestartResponseException(this.getLogoutPageClass(), new PageParameters()));
        OIDCC4UIService service = (OIDCC4UIService)((BaseSession)BaseSession.class.cast(Session.get())).getAnonymousService(OIDCC4UIService.class);
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.getHeaders().addHeader("Cache-Control", "no-cache, no-store");
        response.getHeaders().addHeader("Pragma", "no-cache");
        try {
            service.backChannelLogout(logoutToken, request.getRequestURL().toString());
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("While requesting back-channel logout for token {}", (Object)logoutToken, (Object)e);
            response.setStatusCode(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()));
            response.setContentType("application/json");
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes atrbts) throws IOException {
                    atrbts.getResponse().write((CharSequence)("{\"error\": \"" + e.getMessage() + "\"}"));
                }
            });
        }
        return response;
    }
}

