/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.syncope.client.console.resources.AbstractBpmnProcessResource;
import org.apache.syncope.client.console.rest.BpmnProcessRestClient;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;

@Resource(key="bpmnProcessPUT", path="/bpmnProcessPUT")
public class BpmnProcessPUTResource
extends AbstractBpmnProcessResource {
    private static final long serialVersionUID = 2964542005207297944L;

    public BpmnProcessPUTResource(BpmnProcessRestClient bpmnProcessRestClient) {
        super(bpmnProcessRestClient);
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        String definition = null;
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            String requestBody = IOUtils.toString((InputStream)request.getInputStream());
            String[] split = requestBody.split("&");
            for (int i = 0; i < split.length && definition == null; ++i) {
                String keyValue = split[i];
                if (!keyValue.startsWith("json_xml=")) continue;
                definition = UrlUtils.urlDecode((String)keyValue.split("=")[1]);
            }
        }
        catch (IOException e) {
            LOG.error("Could not extract BPMN process", (Throwable)e);
        }
        BpmnProcess toSet = this.getBpmnProcess(attributes);
        if (definition == null || toSet == null) {
            return new AbstractResource.ResourceResponse().setStatusCode(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "Could not extract BPMN process' model id and / or definition");
        }
        try {
            this.bpmnProcessRestClient.setDefinition(MediaType.APPLICATION_JSON_TYPE, toSet.getKey(), definition);
            return new AbstractResource.ResourceResponse().setStatusCode(Integer.valueOf(Response.Status.NO_CONTENT.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("While updating BPMN process", (Throwable)e);
            return new AbstractResource.ResourceResponse().setStatusCode(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "While updating BPMN process: " + e.getMessage());
        }
    }
}

