/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Locale;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.objects.ObjectClassUtil;

public final class ObjectClass {
    public static final String ACCOUNT_NAME = ObjectClassUtil.createSpecialName("ACCOUNT");
    public static final String GROUP_NAME = ObjectClassUtil.createSpecialName("GROUP");
    public static final String ALL_NAME = ObjectClassUtil.createSpecialName("ALL");
    public static final ObjectClass ACCOUNT = new ObjectClass(ACCOUNT_NAME);
    public static final ObjectClass GROUP = new ObjectClass(GROUP_NAME);
    public static final ObjectClass ALL = new ObjectClass(ALL_NAME);
    private final String type;

    public ObjectClass(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    public String getObjectClassValue() {
        return this.type;
    }

    public String getDisplayNameKey() {
        return "MESSAGE_OBJECT_CLASS_" + this.type.toUpperCase(Locale.US);
    }

    public boolean is(String name) {
        return NameUtil.namesEqual(this.type, name);
    }

    public int hashCode() {
        return NameUtil.nameHashCode(this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ObjectClass other = (ObjectClass)obj;
        return this.is(other.getObjectClassValue());
    }

    public String toString() {
        return "ObjectClass: " + this.type;
    }
}

