/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apereo.services.persondir.IPersonAttributeDao;

public interface PersonDirectoryAttributeRepositoryPlan {
    public void registerAttributeRepository(IPersonAttributeDao var1);

    default public Stream<IPersonAttributeDao> findAttributeRepositories(Predicate<IPersonAttributeDao> filter) {
        return this.getAttributeRepositories().stream().filter(filter);
    }

    default public void registerAttributeRepositories(IPersonAttributeDao ... repository) {
        Arrays.stream(repository).forEach(this::registerAttributeRepository);
    }

    default public void registerAttributeRepositories(List<IPersonAttributeDao> repository) {
        repository.forEach(this::registerAttributeRepository);
    }

    default public boolean isEmpty() {
        return this.getAttributeRepositories().isEmpty();
    }

    public List<IPersonAttributeDao> getAttributeRepositories();
}

