/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.spinner;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.spinner.SpinnerJsReference;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class SpinnerBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private Effect effect = Effect.SPINNER_BORDER;
    private Color spinnerColor;
    private boolean small = true;

    public SpinnerBehavior withEffect(Effect effect) {
        this.effect = (Effect)((Object)Args.notNull((Object)((Object)effect), (String)"effect"));
        return this;
    }

    public SpinnerBehavior withSpinnerColor(Color color) {
        this.spinnerColor = color;
        return this;
    }

    public SpinnerBehavior withSmall(boolean small) {
        this.small = small;
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"ladda-button"});
        Attributes.set((ComponentTag)tag, (String)"data-style", (String)this.effect.cssClassName());
        if (this.small) {
            Attributes.set((ComponentTag)tag, (String)"data-spinner-small", (String)("" + this.small));
        }
        if (this.spinnerColor != null) {
            Attributes.set((ComponentTag)tag, (String)"data-spinner-color", (String)this.spinnerColor.cssClassName());
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SpinnerJsReference.INSTANCE));
    }

    public static enum Color implements ICssClassNameProvider
    {
        TEXT_PRIMARY,
        TEXT_SECONDARY,
        TEXT_SUCCESS,
        TEXT_DANGER,
        TEXT_WARNING,
        TEXT_INFO,
        TEXT_LIGHT,
        TEXT_DARK;


        public String cssClassName() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }

    public static enum Effect implements ICssClassNameProvider
    {
        SPINNER_BORDER,
        SPINNER_GROW;


        public String cssClassName() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }
}

