/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsentActivationStrategy
implements ConsentActivationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsentActivationStrategy.class);
    private final ConsentEngine consentEngine;
    private final CasConfigurationProperties casProperties;

    public boolean isConsentRequired(Service service, RegisteredService registeredService, Authentication authentication, HttpServletRequest requestContext) {
        RegisteredServiceConsentPolicy consentPolicy = registeredService.getAttributeReleasePolicy().getConsentPolicy();
        if (consentPolicy != null) {
            switch (consentPolicy.getStatus()) {
                case TRUE: {
                    LOGGER.trace("Attribute consent is enabled for registered service [{}]", (Object)registeredService.getName());
                    return this.consentEngine.isConsentRequiredFor(service, registeredService, authentication).isRequired();
                }
                case FALSE: {
                    LOGGER.trace("Attribute consent will be skipped as the attribute consent policy for service [{}] is disabled for this request", (Object)registeredService.getName());
                    return false;
                }
            }
            LOGGER.trace("Attribute consent policy for service [{}] is undefined", (Object)registeredService.getName());
        }
        if (this.casProperties.getConsent().getCore().isActive()) {
            LOGGER.trace("Attribute consent is enabled globally for all requests");
            return this.consentEngine.isConsentRequiredFor(service, registeredService, authentication).isRequired();
        }
        LOGGER.trace("Attribute consent will be skipped as neither the attribute consent policy for service [{}] nor the global CAS consent policy are enabled for this request", (Object)registeredService.getName());
        return false;
    }

    @Generated
    public DefaultConsentActivationStrategy(ConsentEngine consentEngine, CasConfigurationProperties casProperties) {
        this.consentEngine = consentEngine;
        this.casProperties = casProperties;
    }
}

