/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.consent.ConsentDecisionBuilder;
import org.apereo.cas.consent.ConsentReminderOptions;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsentDecisionBuilder
implements ConsentDecisionBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsentDecisionBuilder.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final long serialVersionUID = 8220243983483982326L;
    private final transient CipherExecutor<Serializable, String> consentCipherExecutor;

    public ConsentDecision update(ConsentDecision consent, Map<String, List<Object>> attributes) {
        String encodedNames = this.buildAndEncodeConsentAttributes(attributes);
        consent.setAttributes(encodedNames);
        consent.setCreatedDate(LocalDateTime.now(ZoneId.systemDefault()));
        return consent;
    }

    public ConsentDecision build(Service service, RegisteredService registeredService, String principalId, Map<String, List<Object>> attributes) {
        ConsentDecision consent = new ConsentDecision();
        consent.setPrincipal(principalId);
        consent.setService(service.getId());
        return this.update(consent, attributes);
    }

    public boolean doesAttributeReleaseRequireConsent(ConsentDecision decision, Map<String, List<Object>> attributes) {
        Map<String, List<Object>> consentAttributes = this.getConsentableAttributesFrom(decision);
        if (decision.getOptions() == ConsentReminderOptions.ATTRIBUTE_NAME) {
            String currentAttributesHash;
            String consentAttributesHash = DefaultConsentDecisionBuilder.sha512ConsentAttributeNames(consentAttributes);
            return !StringUtils.equals((CharSequence)consentAttributesHash, (CharSequence)(currentAttributesHash = DefaultConsentDecisionBuilder.sha512ConsentAttributeNames(attributes)));
        }
        if (decision.getOptions() == ConsentReminderOptions.ATTRIBUTE_VALUE) {
            String consentAttributesHash = DefaultConsentDecisionBuilder.sha512ConsentAttributeNames(consentAttributes);
            String currentAttributesHash = DefaultConsentDecisionBuilder.sha512ConsentAttributeNames(attributes);
            String consentAttributeValuesHash = DefaultConsentDecisionBuilder.sha512ConsentAttributeValues(consentAttributes);
            String currentAttributeValuesHash = DefaultConsentDecisionBuilder.sha512ConsentAttributeValues(attributes);
            return !StringUtils.equals((CharSequence)consentAttributesHash, (CharSequence)currentAttributesHash) || !StringUtils.equals((CharSequence)consentAttributeValuesHash, (CharSequence)currentAttributeValuesHash);
        }
        return true;
    }

    public Map<String, List<Object>> getConsentableAttributesFrom(ConsentDecision decision) {
        try {
            String result = (String)this.consentCipherExecutor.decode((Object)decision.getAttributes());
            if (StringUtils.isBlank((CharSequence)result)) {
                LOGGER.warn("Unable to decipher attributes from consent decision [{}]", (Object)decision.getId());
                return new HashMap<String, List<Object>>(0);
            }
            String names = EncodingUtils.decodeBase64ToString((String)result);
            return (Map)MAPPER.readValue(JsonValue.readHjson((String)names).toString(), Map.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize attributes for consent decision");
        }
    }

    private static String sha512ConsentAttributeNames(Map<String, List<Object>> attributes) {
        String allNames = String.join((CharSequence)"|", attributes.keySet());
        return DigestUtils.sha512((String)allNames);
    }

    private static String sha512ConsentAttributeValues(Map<String, List<Object>> attributes) {
        String allValues = attributes.values().stream().map(CollectionUtils::toCollection).map(c -> c.stream().map(Object::toString).collect(Collectors.joining())).collect(Collectors.joining("|"));
        return DigestUtils.sha512((String)allValues);
    }

    protected String buildAndEncodeConsentAttributes(Map<String, List<Object>> attributes) {
        try {
            String json = MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString(Objects.requireNonNull(attributes));
            LOGGER.trace("Consentable attributes are [{}]", (Object)json);
            String base64 = EncodingUtils.encodeBase64((String)Objects.requireNonNull(json));
            return (String)this.consentCipherExecutor.encode((Object)base64);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize attributes for consent decision");
        }
    }

    @Generated
    public DefaultConsentDecisionBuilder(CipherExecutor<Serializable, String> consentCipherExecutor) {
        this.consentCipherExecutor = consentCipherExecutor;
    }
}

