/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.SAML2SP4UIIdP;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.SAML2SP4UIIdPCheck;

public class SAML2SP4UIIdPValidator
extends AbstractValidator<SAML2SP4UIIdPCheck, SAML2SP4UIIdP> {
    public boolean isValid(SAML2SP4UIIdP saml2IdP, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (this.isHtml(saml2IdP.getKey())) {
            context.buildConstraintViolationWithTemplate(SAML2SP4UIIdPValidator.getTemplate((EntityViolationType)EntityViolationType.InvalidKey, (String)saml2IdP.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        if (saml2IdP.isSelfRegUnmatching() && saml2IdP.isCreateUnmatching()) {
            context.buildConstraintViolationWithTemplate(SAML2SP4UIIdPValidator.getTemplate((EntityViolationType)EntityViolationType.Standard, (String)"Either selfRegUnmatching or createUnmatching, not both")).addPropertyNode("selfRegUnmatching").addPropertyNode("createUnmatching").addConstraintViolation();
            return false;
        }
        long connObjectKeys = saml2IdP.getItems().stream().filter(Item::isConnObjectKey).count();
        if (!saml2IdP.getItems().isEmpty() && connObjectKeys != 1L) {
            context.buildConstraintViolationWithTemplate(SAML2SP4UIIdPValidator.getTemplate((EntityViolationType)EntityViolationType.InvalidMapping, (String)"Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        boolean[] isValid = new boolean[]{true};
        long passwords = saml2IdP.getItems().stream().filter(Item::isPassword).count();
        if (passwords > 0L) {
            context.buildConstraintViolationWithTemplate(SAML2SP4UIIdPValidator.getTemplate((EntityViolationType)EntityViolationType.InvalidMapping, (String)"No password mapping is allowed")).addPropertyNode("password.size").addConstraintViolation();
            isValid[0] = false;
        }
        return isValid[0];
    }
}

