/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.zookeeper;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.DomainWatcher;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ZookeeperDomainOps
implements DomainOps,
InitializingBean {
    protected static final Logger LOG = LoggerFactory.getLogger(DomainOps.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected static final String DOMAIN_PATH = "/domains";
    @Autowired
    protected CuratorFramework client;
    @Autowired(required=false)
    protected DomainWatcher watcher;

    protected static String buildDomainPath(String ... parts) {
        String prefix = DOMAIN_PATH;
        Object suffix = "";
        if (parts != null && parts.length > 0) {
            suffix = "/" + String.join((CharSequence)"/", parts);
        }
        return prefix + (String)suffix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.watcher != null) {
            if (this.client.checkExists().forPath(ZookeeperDomainOps.buildDomainPath(new String[0])) == null) {
                this.client.create().creatingParentContainersIfNeeded().forPath(ZookeeperDomainOps.buildDomainPath(new String[0]));
            }
            CuratorCache cache = CuratorCache.build((CuratorFramework)this.client, (String)ZookeeperDomainOps.buildDomainPath(new String[0]), (CuratorCache.Options[])new CuratorCache.Options[0]);
            cache.listenable().addListener((type, oldData, newData) -> {
                switch (type) {
                    case NODE_CREATED: {
                        LOG.debug("Domain {} added", (Object)newData.getPath());
                        try {
                            Domain domain = (Domain)MAPPER.readValue(newData.getData(), Domain.class);
                            LOG.info("Domain {} created", (Object)domain.getKey());
                            this.watcher.added(domain);
                        }
                        catch (IOException e) {
                            LOG.debug("Could not parse {}", (Object)new String(newData.getData()), (Object)e);
                        }
                        break;
                    }
                    case NODE_CHANGED: {
                        LOG.debug("Domain {} updated", (Object)newData.getPath());
                        break;
                    }
                    case NODE_DELETED: {
                        LOG.debug("Domain {} removed", (Object)newData.getPath());
                        this.watcher.removed(StringUtils.substringAfter((String)newData.getPath(), (String)"/domains/"));
                        break;
                    }
                    default: {
                        LOG.debug("Event {} received with data {}", (Object)type, (Object)newData);
                    }
                }
            });
            cache.start();
        }
    }

    public List<Domain> list() {
        try {
            if (this.client.checkExists().forPath(ZookeeperDomainOps.buildDomainPath(new String[0])) == null) {
                this.client.create().creatingParentContainersIfNeeded().forPath(ZookeeperDomainOps.buildDomainPath(new String[0]));
            }
            ArrayList<Domain> list = new ArrayList<Domain>();
            for (String child : (List)this.client.getChildren().forPath(ZookeeperDomainOps.buildDomainPath(new String[0]))) {
                list.add((Domain)MAPPER.readValue((byte[])this.client.getData().forPath(ZookeeperDomainOps.buildDomainPath(child)), Domain.class));
            }
            return list;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public Domain read(String key) {
        try {
            return (Domain)MAPPER.readValue((byte[])this.client.getData().forPath(ZookeeperDomainOps.buildDomainPath(key)), Domain.class);
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public void create(Domain domain) {
        if (Objects.equals(domain.getKey(), "Master")) {
            throw new KeymasterException("Cannot create domain Master");
        }
        try {
            if (this.client.checkExists().forPath(ZookeeperDomainOps.buildDomainPath(domain.getKey())) != null) {
                throw new KeymasterException("Domain " + domain.getKey() + " existing");
            }
            this.client.create().creatingParentContainersIfNeeded().forPath(ZookeeperDomainOps.buildDomainPath(domain.getKey()), MAPPER.writeValueAsBytes((Object)domain));
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public void changeAdminPassword(String key, String password, CipherAlgorithm cipherAlgorithm) {
        try {
            Domain domain = this.read(key);
            domain.setAdminPassword(password);
            domain.setAdminCipherAlgorithm(cipherAlgorithm);
            this.client.setData().forPath(ZookeeperDomainOps.buildDomainPath(key), MAPPER.writeValueAsBytes((Object)domain));
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public void adjustPoolSize(String key, int poolMaxActive, int poolMinIdle) {
        try {
            Domain domain = this.read(key);
            domain.setPoolMaxActive(poolMaxActive);
            domain.setPoolMinIdle(poolMinIdle);
            this.client.setData().forPath(ZookeeperDomainOps.buildDomainPath(key), MAPPER.writeValueAsBytes((Object)domain));
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public void delete(String key) {
        try {
            this.client.delete().forPath(ZookeeperDomainOps.buildDomainPath(key));
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }
}

