/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpUtils;
import org.pac4j.http.profile.RestProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAuthenticator
extends ProfileDefinitionAware
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(RestAuthenticator.class);
    private ObjectMapper mapper;
    private String url;

    public RestAuthenticator() {
    }

    public RestAuthenticator(String url) {
        this.url = url;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"url", (String)this.url);
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new RestProfile()));
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }

    public void validate(Credentials cred, WebContext context, SessionStore sessionStore) {
        this.init();
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)cred;
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (CommonHelper.isBlank((String)username) || CommonHelper.isBlank((String)password)) {
            logger.info("Empty username or password");
            return;
        }
        String body = this.callRestApi(username, password);
        logger.debug("body: {}", (Object)body);
        if (body != null) {
            this.buildProfile(credentials, body);
        }
    }

    protected void buildProfile(UsernamePasswordCredentials credentials, String body) {
        RestProfile profile;
        RestProfile profileClass = (RestProfile)this.getProfileDefinition().newProfile(new Object[0]);
        try {
            profile = (RestProfile)((Object)this.mapper.readValue(body, ((Object)((Object)profileClass)).getClass()));
        }
        catch (IOException e) {
            throw new TechnicalException((Throwable)e);
        }
        logger.debug("profile: {}", (Object)profile);
        credentials.setUserProfile((UserProfile)profile);
    }

    protected String callRestApi(String username, String password) {
        String string;
        HttpURLConnection connection;
        block7: {
            int code;
            block6: {
                String basicAuth = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
                HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
                headers.put("Authorization", (CallSite)((Object)("Basic " + basicAuth)));
                connection = null;
                connection = HttpUtils.openPostConnection((URL)new URL(this.url), headers);
                code = connection.getResponseCode();
                if (code != 200) break block6;
                logger.debug("Authentication success for username: {}", (Object)username);
                String string2 = HttpUtils.readBody((HttpURLConnection)connection);
                HttpUtils.closeConnection((HttpURLConnection)connection);
                return string2;
            }
            if (code != 401 && code != 403) break block7;
            logger.info("Authentication failure for username: {} -> {}", (Object)username, (Object)HttpUtils.buildHttpErrorMessage((HttpURLConnection)connection));
            String string3 = null;
            HttpUtils.closeConnection((HttpURLConnection)connection);
            return string3;
        }
        try {
            logger.warn("Unexpected error for username: {} -> {}", (Object)username, (Object)HttpUtils.buildHttpErrorMessage((HttpURLConnection)connection));
            string = null;
        }
        catch (IOException e) {
            try {
                throw new TechnicalException((Throwable)e);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection((HttpURLConnection)connection);
        return string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"url", this.url, "mapper", this.mapper});
    }
}

