/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.Attributable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class AjaxCheckBoxPanel
extends FieldPanel<Boolean> {
    private static final long serialVersionUID = 5664138233103884310L;

    public AjaxCheckBoxPanel(String id, String name, IModel<Boolean> model) {
        this(id, name, model, true);
    }

    public AjaxCheckBoxPanel(String id, String name, IModel<Boolean> model, boolean enableOnChange) {
        super(id, name, model);
        this.field = new CheckBox("checkboxField", model);
        this.add(new Component[]{this.field.setLabel((IModel)new ResourceModel(name, name)).setOutputMarkupId(true)});
        if (enableOnChange && !this.isReadOnly()) {
            this.field.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
    }

    @Override
    public FieldPanel<Boolean> setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model<Boolean>(){
            private static final long serialVersionUID = 527651414610325237L;

            public Boolean getObject() {
                Boolean value = null;
                if (list != null && !list.isEmpty()) {
                    value = Boolean.TRUE.toString().equalsIgnoreCase(((Serializable)list.get(0)).toString());
                }
                return value;
            }

            public void setObject(Boolean object) {
                list.clear();
                if (object != null) {
                    list.add(object.toString());
                }
            }
        });
        return this;
    }

    @Override
    public FieldPanel<Boolean> setNewModel(final ListItem item) {
        Model<Boolean> model = new Model<Boolean>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Boolean getObject() {
                Boolean bool = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        bool = Boolean.TRUE.toString().equalsIgnoreCase(obj.toString());
                    } else if (obj instanceof Boolean) {
                        bool = (Boolean)obj;
                    }
                }
                return bool;
            }

            public void setObject(Boolean object) {
                item.setModelObject((Object)Optional.ofNullable(object).map(Object::toString).orElseGet(Boolean.FALSE::toString));
            }
        };
        this.field.setModel((IModel)model);
        return this;
    }

    @Override
    public FieldPanel<Boolean> setNewModel(final Attributable attributable, final String schema) {
        this.field.setModel((IModel)new Model(){
            private static final long serialVersionUID = -4214654722524358000L;

            public Serializable getObject() {
                return attributable.getPlainAttr(schema).map(Attr::getValues).filter(Predicate.not(List::isEmpty)).map(values -> Boolean.TRUE.toString().equalsIgnoreCase((String)values.get(0))).orElse(null);
            }

            public void setObject(Serializable object) {
                attributable.getPlainAttr(schema).ifPresent(plainAttr -> {
                    plainAttr.getValues().clear();
                    plainAttr.getValues().add(object == null ? Boolean.FALSE.toString() : object.toString());
                });
            }
        });
        return this;
    }
}

