/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.form.NumberTextField;
import com.googlecode.wicket.kendo.ui.resource.KendoCultureResourceReference;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.Attributable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.ResourceReference;

public final class AjaxNumberFieldPanel<T extends Number>
extends FieldPanel<T> {
    private static final long serialVersionUID = 6413819574530703577L;
    private final Class<T> reference;
    private final IModel<T> model;
    private final Options options;
    private final boolean enableOnChange;
    private final boolean convertValuesToString;

    public static <T extends Number> Class<T> cast(Class<?> clazz) {
        return clazz;
    }

    private AjaxNumberFieldPanel(String id, String name, Class<T> reference, IModel<T> model, Options options, boolean enableOnChange, boolean convertValuesToString) {
        super(id, name, model);
        this.reference = reference;
        this.model = model;
        this.options = options;
        this.enableOnChange = enableOnChange;
        this.convertValuesToString = convertValuesToString;
        this.field = new NumberTextField<T>("numberTextField", model, reference, options){
            private static final long serialVersionUID = -8837755342786762653L;

            protected String getModelValue() {
                Number value = (Number)this.getModelObject();
                return value == null ? "" : value.toString().trim();
            }
        };
        if (enableOnChange && !this.isReadOnly()) {
            this.field.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
        this.add(new Component[]{this.field.setLabel((IModel)new ResourceModel(name, name)).setOutputMarkupId(true)});
    }

    @Override
    public FieldPanel<T> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        ((NumberTextField)NumberTextField.class.cast(this.field)).setEnabled(!readOnly);
        return this;
    }

    @Override
    public AjaxNumberFieldPanel<T> setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model<T>(){
            private static final long serialVersionUID = 527651414610325237L;

            public T getObject() {
                Number value = null;
                if (list != null && !list.isEmpty() && list.get(0) != null && !((Serializable)list.get(0)).toString().isEmpty()) {
                    value = AjaxNumberFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toInt((String)((Serializable)list.get(0)).toString()))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toLong((String)((Serializable)list.get(0)).toString()))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toShort((String)((Serializable)list.get(0)).toString()))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Float.valueOf(NumberUtils.toFloat((String)((Serializable)list.get(0)).toString())))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toByte((String)((Serializable)list.get(0)).toString()))) : (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toDouble((String)((Serializable)list.get(0)).toString())))))));
                }
                return value;
            }

            public void setObject(T object) {
                list.clear();
                Optional.ofNullable(object).ifPresent(v -> list.add(AjaxNumberFieldPanel.this.convertValuesToString ? v.toString() : v));
            }
        });
        return this;
    }

    @Override
    public AjaxNumberFieldPanel<T> setNewModel(final ListItem item) {
        this.field.setModel((IModel)new Model<T>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public T getObject() {
                Number number = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        try {
                            number = AjaxNumberFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Integer.valueOf((String)obj))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Long.valueOf((String)obj))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Short.valueOf((String)obj))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Float.valueOf((String)obj))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Byte.valueOf((String)obj))) : (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Double.valueOf((String)obj)))))));
                        }
                        catch (NumberFormatException e) {
                            AbstractFieldPanel.LOG.error("While attempting to parse {}", obj, (Object)e);
                        }
                    } else if (obj instanceof Number) {
                        number = AjaxNumberFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(((Number)obj).intValue())) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(((Number)obj).longValue())) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(((Number)obj).shortValue())) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Float.valueOf(((Number)obj).floatValue()))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(((Number)obj).byteValue())) : (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(((Number)obj).doubleValue()))))));
                    }
                }
                return number;
            }

            public void setObject(T object) {
                item.setModelObject(Optional.ofNullable(object).map(v -> AjaxNumberFieldPanel.this.convertValuesToString ? v.toString() : v).orElse(null));
            }
        });
        return this;
    }

    @Override
    public FieldPanel<T> setNewModel(final Attributable attributable, final String schema) {
        this.field.setModel((IModel)new Model<T>(){
            private static final long serialVersionUID = -4214654722524358000L;

            public T getObject() {
                return attributable.getPlainAttr(schema).map(Attr::getValues).filter(Predicate.not(List::isEmpty)).map(values -> AjaxNumberFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toInt((String)((String)values.get(0))))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toLong((String)((String)values.get(0))))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toShort((String)((String)values.get(0))))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(Float.valueOf(NumberUtils.toFloat((String)((String)values.get(0)))))) : (Number)(AjaxNumberFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toByte((String)((String)values.get(0))))) : (Number)((Number)AjaxNumberFieldPanel.this.reference.cast(NumberUtils.toDouble((String)((String)values.get(0)))))))))).orElse(null);
            }

            public void setObject(T object) {
                attributable.getPlainAttr(schema).ifPresent(plainAttr -> {
                    plainAttr.getValues().clear();
                    Optional.ofNullable(object).ifPresent(o -> plainAttr.getValues().add(o.toString()));
                });
            }
        });
        return this;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new KendoCultureResourceReference(this.getLocale())));
    }

    @Override
    public AjaxNumberFieldPanel<T> clone() {
        AjaxNumberFieldPanel<T> panel = new AjaxNumberFieldPanel<T>(this.getId(), this.name, this.reference, this.model, this.options, this.enableOnChange, this.convertValuesToString);
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        return panel;
    }

    public static class Builder<T extends Number> {
        private final Options options = new Options();
        private boolean enableOnChange = false;
        private boolean convertValuesToString = true;

        public Builder<T> min(T min) {
            this.options.set("min", min);
            return this;
        }

        public Builder<T> max(T max) {
            this.options.set("max", max);
            return this;
        }

        public Builder<T> format(String format) {
            this.options.set("format", (Object)format);
            return this;
        }

        public Builder<T> step(T step) {
            this.options.set("step", step);
            return this;
        }

        public Builder<T> options(Options options) {
            options.entries().forEach(e -> this.options.set((String)e.getKey(), e.getValue()));
            return this;
        }

        public Builder<T> enableOnChange() {
            this.enableOnChange = true;
            return this;
        }

        public Builder<T> convertValuesToString(boolean convertValuesToString) {
            this.convertValuesToString = convertValuesToString;
            return this;
        }

        public AjaxNumberFieldPanel<T> build(String id, String name, Class<T> reference, IModel<T> model) {
            if (this.options.entries().stream().noneMatch(e -> "decimals".equals(e.getKey()))) {
                this.options.set("decimals", (Object)"10");
            }
            if (this.options.entries().stream().noneMatch(o -> "format".equalsIgnoreCase((String)o.getKey()))) {
                if (reference.equals(Integer.class) || reference.equals(Long.class) || reference.equals(Short.class)) {
                    this.options.set("format", (Object)"'#'");
                } else {
                    this.options.set("format", (Object)"'#.##########'");
                }
            }
            if (this.options.entries().stream().noneMatch(o -> "step".equalsIgnoreCase((String)o.getKey()))) {
                if (reference.equals(Integer.class) || reference.equals(Long.class) || reference.equals(Short.class)) {
                    this.options.set("step", (Object)"1");
                } else {
                    this.options.set("step", (Object)"0.000000001");
                }
            }
            return new AjaxNumberFieldPanel<T>(id, name, reference, model, this.options, this.enableOnChange, this.convertValuesToString);
        }
    }
}

