/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.proxy.BucketNotFoundException;
import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BucketNotFoundError
implements CommandError,
ComparableByContent<BucketNotFoundError> {
    private static final BucketNotFoundError INSTANCE = new BucketNotFoundError();
    public static SerializationHandle<BucketNotFoundError> SERIALIZATION_HANDLE = new SerializationHandle<BucketNotFoundError>(){

        @Override
        public <S> BucketNotFoundError deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            return INSTANCE;
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, BucketNotFoundError error, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
        }

        @Override
        public int getTypeId() {
            return 15;
        }

        @Override
        public Class<BucketNotFoundError> getSerializedType() {
            return BucketNotFoundError.class;
        }

        @Override
        public BucketNotFoundError fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            return INSTANCE;
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(BucketNotFoundError error, Version backwardCompatibilityVersion) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            return result;
        }

        @Override
        public String getTypeName() {
            return "BucketNotFoundError";
        }
    };

    @Override
    public RuntimeException asException() {
        return new BucketNotFoundException();
    }

    @Override
    public boolean equalsByContent(BucketNotFoundError other) {
        return true;
    }
}

