/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.attrvalue.validation;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.attrvalue.validation.AbstractValidator;
import org.apache.tika.Tika;

public class BinaryValidator
extends AbstractValidator {
    private static final long serialVersionUID = 1344152444666540361L;
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private static final Tika TIKA = new Tika();

    @Override
    protected void doValidate(PlainSchema schema, PlainAttrValue attrValue) {
        if (attrValue.getBinaryValue() != null) {
            byte[] binaryValue = attrValue.getBinaryValue();
            String mimeType = TIKA.detect(binaryValue);
            boolean valid = true;
            if (!mimeType.equals(attrValue.getAttr().getSchema().getMimeType())) {
                String decoded;
                valid = "text/plain".equals(mimeType) && "application/json".equals(attrValue.getAttr().getSchema().getMimeType()) ? (decoded = new String(binaryValue).trim()).startsWith("{") && decoded.endsWith("}") || decoded.startsWith("[") && decoded.endsWith("]") && BinaryValidator.isValidJSON(decoded) : false;
            }
            if (!valid) {
                throw new InvalidPlainAttrValueException("Found MIME type: '" + mimeType + "', expecting: '" + attrValue.getAttr().getSchema().getMimeType() + "'");
            }
        }
    }

    private static boolean isValidJSON(String value) {
        try {
            MAPPER.readTree(value);
            return true;
        }
        catch (IOException e) {
            LOG.debug("Invalid JSON string: {}", (Object)value, (Object)e);
            return false;
        }
    }

    static {
        TIKA.setMaxStringLength(-1);
    }
}

