/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.time.OffsetDateTime;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.api.dao.BatchDAO;
import org.apache.syncope.core.persistence.api.entity.Batch;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPABatch;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class JPABatchDAO
extends AbstractDAO<Batch>
implements BatchDAO {
    @Transactional(readOnly=true)
    public Batch find(String key) {
        return (Batch)this.entityManager().find(JPABatch.class, (Object)key);
    }

    public Batch save(Batch batch) {
        return (Batch)this.entityManager().merge((Object)batch);
    }

    public void delete(String key) {
        Batch batch = this.find(key);
        if (batch == null) {
            return;
        }
        this.entityManager().remove((Object)batch);
    }

    public int deleteExpired() {
        Query query = this.entityManager().createQuery("DELETE FROM " + JPABatch.class.getSimpleName() + " e WHERE e.expiryTime < :now");
        query.setParameter("now", (Object)OffsetDateTime.now());
        return query.executeUpdate();
    }
}

