/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnyDAO;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAADynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAMembership;
import org.apache.syncope.core.persistence.jpa.entity.group.JPATypeExtension;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUDynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public class JPAGroupDAO
extends AbstractAnyDAO<Group>
implements GroupDAO {
    public static final String UDYNMEMB_TABLE = "UDynGroupMembers";
    public static final String ADYNMEMB_TABLE = "ADynGroupMembers";
    protected final ApplicationEventPublisher publisher;
    protected final AnyMatchDAO anyMatchDAO;
    protected final PlainAttrDAO plainAttrDAO;
    protected final UserDAO userDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final SearchCondVisitor searchCondVisitor;

    public JPAGroupDAO(AnyUtilsFactory anyUtilsFactory, ApplicationEventPublisher publisher, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, DynRealmDAO dynRealmDAO, AnyMatchDAO anyMatchDAO, PlainAttrDAO plainAttrDAO, UserDAO userDAO, AnyObjectDAO anyObjectDAO, AnySearchDAO searchDAO, SearchCondVisitor searchCondVisitor) {
        super(anyUtilsFactory, plainSchemaDAO, derSchemaDAO, dynRealmDAO);
        this.publisher = publisher;
        this.anyMatchDAO = anyMatchDAO;
        this.plainAttrDAO = plainAttrDAO;
        this.userDAO = userDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.anySearchDAO = searchDAO;
        this.searchCondVisitor = searchCondVisitor;
    }

    @Override
    protected AnyUtils init() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP);
    }

    @Transactional(readOnly=true)
    public String findKey(String name) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM SyncopeGroup WHERE name=?");
        query.setParameter(1, (Object)name);
        String key = null;
        for (Object resultKey : query.getResultList()) {
            key = resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey;
        }
        return key;
    }

    @Transactional(readOnly=true)
    public OffsetDateTime findLastChange(String key) {
        return this.findLastChange(key, "SyncopeGroup");
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM " + this.anyUtils().anyClass().getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public Map<String, Integer> countByRealm() {
        Query query = this.entityManager().createQuery("SELECT e.realm, COUNT(e) FROM " + this.anyUtils().anyClass().getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> ((Realm)result[0]).getFullPath(), result -> ((Number)result[1]).intValue()));
    }

    @Transactional(readOnly=true)
    public void securityChecks(Set<String> authRealms, String key, String realm) {
        boolean authorized = authRealms.stream().anyMatch(authRealm -> realm.startsWith((String)authRealm) || authRealm.equals(RealmUtils.getGroupOwnerRealm((String)realm, (String)key)));
        if (!authorized) {
            authorized = this.findDynRealms(key).stream().anyMatch(authRealms::contains);
        }
        if (authRealms.isEmpty() || !authorized) {
            throw new DelegatedAdministrationException(realm, AnyTypeKind.GROUP.name(), key);
        }
    }

    @Override
    protected void securityChecks(Group group) {
        Set<String> authRealms = AuthContextUtils.getAuthorizations().getOrDefault("GROUP_READ", Set.of());
        this.securityChecks(authRealms, group.getKey(), group.getRealm().getFullPath());
    }

    public Group findByName(String name) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.name = :name", Group.class);
        query.setParameter("name", (Object)name);
        Group result = null;
        try {
            result = (Group)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No group found with name {}", (Object)name, (Object)e);
        }
        return result;
    }

    public List<String> findKeysByNamePattern(String pattern) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM SyncopeGroup WHERE LOWER(name) LIKE LOWER(?1)");
        query.setParameter(1, (Object)pattern);
        List raw = query.getResultList();
        return raw.stream().map(Object::toString).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<Group> findOwnedByUser(String userKey) {
        User owner = (User)this.userDAO.find(userKey);
        if (owner == null) {
            return List.of();
        }
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(this.anyUtils().anyClass().getSimpleName()).append(" e WHERE e.userOwner=:owner ");
        this.userDAO.findAllGroupKeys(owner).forEach(groupKey -> queryString.append("OR e.groupOwner.id='").append((String)groupKey).append("' "));
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), Group.class);
        query.setParameter("owner", (Object)owner);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<Group> findOwnedByGroup(String groupKey) {
        Group owner = (Group)this.find(groupKey);
        if (owner == null) {
            return List.of();
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.groupOwner=:owner", Group.class);
        query.setParameter("owner", (Object)owner);
        return query.getResultList();
    }

    public List<AMembership> findAMemberships(Group group) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group", AMembership.class);
        query.setParameter("group", (Object)group);
        return query.getResultList();
    }

    public List<UMembership> findUMemberships(Group group) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group", UMembership.class);
        query.setParameter("group", (Object)group);
        return query.getResultList();
    }

    public List<UMembership> findUMemberships(Group group, int page, int itemsPerPage) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group ORDER BY e.leftEnd", UMembership.class);
        query.setParameter("group", (Object)group);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        query.setMaxResults(itemsPerPage);
        return query.getResultList();
    }

    public List<Group> findAll(int page, int itemsPerPage) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e ORDER BY e.id", Group.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        query.setMaxResults(itemsPerPage);
        return query.getResultList();
    }

    public List<String> findAllKeys(int page, int itemsPerPage) {
        return this.findAllKeys("SyncopeGroup", page, itemsPerPage);
    }

    protected SearchCond buildDynMembershipCond(String baseCondFIQL) {
        return SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)baseCondFIQL, (String[])new String[0]);
    }

    public Group saveAndRefreshDynMemberships(Group group) {
        Group merged = this.save(group);
        this.clearUDynMembers(merged);
        if (merged.getUDynMembership() != null) {
            SearchCond cond = this.buildDynMembershipCond(merged.getUDynMembership().getFIQLCond());
            int count = this.anySearchDAO.count(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, AnyTypeKind.USER);
            for (int page = 1; page <= count / 500 + 1; ++page) {
                List matching = this.anySearchDAO.search(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, page, 500, List.of(), AnyTypeKind.USER);
                matching.forEach(user -> {
                    Query insert = this.entityManager().createNativeQuery("INSERT INTO UDynGroupMembers VALUES(?, ?)");
                    insert.setParameter(1, (Object)user.getKey());
                    insert.setParameter(2, (Object)merged.getKey());
                    insert.executeUpdate();
                    this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)user, AuthContextUtils.getDomain()));
                });
            }
        }
        this.clearADynMembers(merged);
        merged.getADynMemberships().forEach(memb -> {
            SearchCond cond = this.buildDynMembershipCond(memb.getFIQLCond());
            int count = this.anySearchDAO.count(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, AnyTypeKind.ANY_OBJECT);
            for (int page = 1; page <= count / 500 + 1; ++page) {
                List matching = this.anySearchDAO.search(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, page, 500, List.of(), AnyTypeKind.ANY_OBJECT);
                matching.forEach(any -> {
                    Query insert = this.entityManager().createNativeQuery("INSERT INTO ADynGroupMembers VALUES(?, ?, ?)");
                    insert.setParameter(1, (Object)any.getType().getKey());
                    insert.setParameter(2, (Object)any.getKey());
                    insert.setParameter(3, (Object)merged.getKey());
                    insert.executeUpdate();
                    this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)any, AuthContextUtils.getDomain()));
                });
            }
        });
        this.dynRealmDAO.refreshDynMemberships((Any)merged);
        return merged;
    }

    public void delete(Group group) {
        this.dynRealmDAO.removeDynMemberships(group.getKey());
        this.findAMemberships(group).forEach(membership -> {
            AnyObject leftEnd = (AnyObject)membership.getLeftEnd();
            leftEnd.remove((Membership)membership);
            membership.setRightEnd(null);
            leftEnd.getPlainAttrs((Membership)membership).forEach(attr -> {
                leftEnd.remove((PlainAttr)attr);
                attr.setOwner(null);
                attr.setMembership(null);
                this.plainAttrDAO.delete((PlainAttr)attr);
            });
            this.anyObjectDAO.save((Any)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)leftEnd, AuthContextUtils.getDomain()));
        });
        this.findUMemberships(group).forEach(membership -> {
            User leftEnd = (User)membership.getLeftEnd();
            leftEnd.remove((Membership)membership);
            membership.setRightEnd(null);
            leftEnd.getPlainAttrs((Membership)membership).forEach(attr -> {
                leftEnd.remove((PlainAttr)attr);
                attr.setOwner(null);
                attr.setMembership(null);
                this.plainAttrDAO.delete((PlainAttr)attr);
            });
            this.userDAO.save((Any)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)leftEnd, AuthContextUtils.getDomain()));
        });
        this.clearUDynMembers(group);
        this.clearADynMembers(group);
        this.entityManager().remove((Object)group);
    }

    public List<TypeExtension> findTypeExtensions(AnyTypeClass anyTypeClass) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPATypeExtension.class.getSimpleName() + " e WHERE :anyTypeClass MEMBER OF e.auxClasses", TypeExtension.class);
        query.setParameter("anyTypeClass", (Object)anyTypeClass);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public boolean existsAMembership(String anyObjectKey, String groupKey) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(*) FROM AMembership WHERE group_id=? AND anyobject_it=?");
        query.setParameter(1, (Object)groupKey);
        query.setParameter(2, (Object)anyObjectKey);
        return ((Number)query.getSingleResult()).intValue() > 0;
    }

    @Transactional(readOnly=true)
    public boolean existsUMembership(String userKey, String groupKey) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(*) FROM UMembership WHERE group_id=? AND user_id=?");
        query.setParameter(1, (Object)groupKey);
        query.setParameter(2, (Object)userKey);
        return ((Number)query.getSingleResult()).intValue() > 0;
    }

    @Transactional(readOnly=true)
    public List<String> findAMembers(String groupKey) {
        Query query = this.entityManager().createNativeQuery("SELECT DISTINCT anyObject_id FROM AMembership WHERE group_id=?");
        query.setParameter(1, (Object)groupKey);
        ArrayList<String> result = new ArrayList<String>();
        query.getResultList().stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).forEach(item -> result.add((String)item));
        return result;
    }

    @Transactional(readOnly=true)
    public List<String> findUMembers(String groupKey) {
        Query query = this.entityManager().createNativeQuery("SELECT DISTINCT user_id FROM UMembership WHERE group_id=?");
        query.setParameter(1, (Object)groupKey);
        ArrayList<String> result = new ArrayList<String>();
        query.getResultList().stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).forEach(item -> result.add((String)item));
        return result;
    }

    public List<String> findADynMembers(Group group) {
        ArrayList<String> result = new ArrayList<String>();
        group.getADynMemberships().forEach(memb -> {
            Query query = this.entityManager().createNativeQuery("SELECT DISTINCT any_id FROM ADynGroupMembers WHERE group_id=? AND anyType_id=?");
            query.setParameter(1, (Object)group.getKey());
            query.setParameter(2, (Object)memb.getAnyType().getKey());
            query.getResultList().stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).filter(anyObject -> !result.contains((String)anyObject)).forEach(anyObject -> result.add((String)anyObject));
        });
        return result;
    }

    public int countAMembers(String groupKey) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(DISTINCT anyObject_id) FROM AMembership WHERE group_id=?");
        query.setParameter(1, (Object)groupKey);
        return ((Number)query.getSingleResult()).intValue();
    }

    public int countUMembers(String groupKey) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(DISTINCT user_id) FROM UMembership WHERE group_id=?");
        query.setParameter(1, (Object)groupKey);
        return ((Number)query.getSingleResult()).intValue();
    }

    public int countADynMembers(Group group) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(DISTINCT any_id) FROM ADynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).intValue();
    }

    public int countUDynMembers(Group group) {
        if (group.getUDynMembership() == null) {
            return 0;
        }
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(DISTINCT any_id) FROM UDynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).intValue();
    }

    public void clearADynMembers(Group group) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM ADynGroupMembers WHERE group_id=?");
        delete.setParameter(1, (Object)group.getKey());
        delete.executeUpdate();
    }

    protected List<ADynGroupMembership> findWithADynMemberships(AnyType anyType) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAADynGroupMembership.class.getSimpleName() + " e  WHERE e.anyType=:anyType", ADynGroupMembership.class);
        query.setParameter("anyType", (Object)anyType);
        return query.getResultList();
    }

    @Transactional
    public Pair<Set<String>, Set<String>> refreshDynMemberships(AnyObject anyObject) {
        HashSet before = new HashSet();
        HashSet after = new HashSet();
        this.findWithADynMemberships(anyObject.getType()).forEach(memb -> {
            boolean existing;
            boolean matches = this.anyMatchDAO.matches((Any)anyObject, this.buildDynMembershipCond(memb.getFIQLCond()));
            if (matches) {
                after.add(memb.getGroup().getKey());
            }
            Query query = this.entityManager().createNativeQuery("SELECT COUNT(group_id) FROM ADynGroupMembers WHERE group_id=? AND any_id=?");
            query.setParameter(1, (Object)memb.getGroup().getKey());
            query.setParameter(2, (Object)anyObject.getKey());
            boolean bl = existing = ((Number)query.getSingleResult()).longValue() > 0L;
            if (existing) {
                before.add(memb.getGroup().getKey());
            }
            if (matches && !existing) {
                Query insert = this.entityManager().createNativeQuery("INSERT INTO ADynGroupMembers VALUES(?, ?, ?)");
                insert.setParameter(1, (Object)anyObject.getType().getKey());
                insert.setParameter(2, (Object)anyObject.getKey());
                insert.setParameter(3, (Object)memb.getGroup().getKey());
                insert.executeUpdate();
            } else if (!matches && existing) {
                Query delete = this.entityManager().createNativeQuery("DELETE FROM ADynGroupMembers WHERE group_id=? AND any_id=?");
                delete.setParameter(1, (Object)memb.getGroup().getKey());
                delete.setParameter(2, (Object)anyObject.getKey());
                delete.executeUpdate();
            }
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)memb.getGroup(), AuthContextUtils.getDomain()));
        });
        return Pair.of(before, after);
    }

    public Set<String> removeDynMemberships(AnyObject anyObject) {
        List dynGroups = this.anyObjectDAO.findDynGroups(anyObject.getKey());
        Query delete = this.entityManager().createNativeQuery("DELETE FROM ADynGroupMembers WHERE any_id=?");
        delete.setParameter(1, (Object)anyObject.getKey());
        delete.executeUpdate();
        HashSet<String> before = new HashSet<String>();
        dynGroups.forEach(group -> {
            before.add(group.getKey());
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)group, AuthContextUtils.getDomain()));
        });
        return before;
    }

    public List<String> findUDynMembers(Group group) {
        if (group.getUDynMembership() == null) {
            return List.of();
        }
        Query query = this.entityManager().createNativeQuery("SELECT DISTINCT any_id FROM UDynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        ArrayList<String> result = new ArrayList<String>();
        query.getResultList().stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).forEach(user -> result.add((String)user));
        return result;
    }

    public void clearUDynMembers(Group group) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM UDynGroupMembers WHERE group_id=?");
        delete.setParameter(1, (Object)group.getKey());
        delete.executeUpdate();
    }

    protected List<UDynGroupMembership> findWithUDynMemberships() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUDynGroupMembership.class.getSimpleName() + " e", UDynGroupMembership.class);
        return query.getResultList();
    }

    @Transactional
    public Pair<Set<String>, Set<String>> refreshDynMemberships(User user) {
        HashSet before = new HashSet();
        HashSet after = new HashSet();
        this.findWithUDynMemberships().forEach(memb -> {
            boolean existing;
            boolean matches = this.anyMatchDAO.matches((Any)user, this.buildDynMembershipCond(memb.getFIQLCond()));
            if (matches) {
                after.add(memb.getGroup().getKey());
            }
            Query query = this.entityManager().createNativeQuery("SELECT COUNT(group_id) FROM UDynGroupMembers WHERE group_id=? AND any_id=?");
            query.setParameter(1, (Object)memb.getGroup().getKey());
            query.setParameter(2, (Object)user.getKey());
            boolean bl = existing = ((Number)query.getSingleResult()).longValue() > 0L;
            if (existing) {
                before.add(memb.getGroup().getKey());
            }
            if (matches && !existing) {
                Query insert = this.entityManager().createNativeQuery("INSERT INTO UDynGroupMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)user.getKey());
                insert.setParameter(2, (Object)memb.getGroup().getKey());
                insert.executeUpdate();
            } else if (!matches && existing) {
                Query delete = this.entityManager().createNativeQuery("DELETE FROM UDynGroupMembers WHERE group_id=? AND any_id=?");
                delete.setParameter(1, (Object)memb.getGroup().getKey());
                delete.setParameter(2, (Object)user.getKey());
                delete.executeUpdate();
            }
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)memb.getGroup(), AuthContextUtils.getDomain()));
        });
        return Pair.of(before, after);
    }

    public Set<String> removeDynMemberships(User user) {
        List dynGroups = this.userDAO.findDynGroups(user.getKey());
        Query delete = this.entityManager().createNativeQuery("DELETE FROM UDynGroupMembers WHERE any_id=?");
        delete.setParameter(1, (Object)user.getKey());
        delete.executeUpdate();
        HashSet<String> before = new HashSet<String>();
        dynGroups.forEach(group -> {
            before.add(group.getKey());
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)group, AuthContextUtils.getDomain()));
        });
        return before;
    }

    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return ((Group)this.find(key)).getResources().stream().map(Entity::getKey).collect(Collectors.toList());
    }
}

