/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.RealmCheck;

public class RealmValidator
extends AbstractValidator<RealmCheck, Realm> {
    public boolean isValid(Realm realm, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if ("/".equals(realm.getName())) {
            if (realm.getParent() != null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(RealmValidator.getTemplate(EntityViolationType.InvalidRealm, "Root realm cannot have a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
        } else {
            if (realm.getParent() == null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(RealmValidator.getTemplate(EntityViolationType.InvalidRealm, "A realm needs to reference a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
            if (!RealmDAO.NAME_PATTERN.matcher(realm.getName()).matches()) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(RealmValidator.getTemplate(EntityViolationType.InvalidRealm, "Only alphanumeric chars allowed in realm name")).addPropertyNode("name").addConstraintViolation();
            }
        }
        return isValid;
    }
}

