/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.ConnectionIdLogger;
import com.tc.logging.LossyTCLogger;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.ReconnectionRejectedException;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.NoActiveException;
import com.tc.net.protocol.transport.TransportRedirect;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.CompositeIterator;
import com.tc.util.TCTimeoutException;
import com.tc.util.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionEstablisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnectionEstablisher.class);
    private static final long CONNECT_RETRY_INTERVAL;
    private static final long MIN_RETRY_INTERVAL = 1000L;
    public static final String RECONNECT_THREAD_NAME = "ConnectionEstablisher";
    private volatile Iterable<InetSocketAddress> serverAddresses;
    private final Set<InetSocketAddress> redirects = new LinkedHashSet<InetSocketAddress>();
    private final ClientMessageTransport transport;
    private boolean allowReconnects = false;
    private AsyncReconnect asyncReconnect;

    public ClientConnectionEstablisher(ClientMessageTransport cmt) {
        this.transport = cmt;
    }

    public NetworkStackID open(Iterable<InetSocketAddress> serverAddresses, ClientConnectionErrorListener reporter) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.assertNotNull(this.transport);
        Assert.assertNotNull(reporter);
        Assert.assertNotNull(serverAddresses);
        Assert.assertFalse(this.transport.wasOpened());
        if (this.enableReconnects()) {
            this.setServerAddresses(serverAddresses);
            try {
                return this.connectTryAllOnce(reporter);
            }
            catch (CommStackMismatchException | MaxConnectionsExceededException | TCTimeoutException | IOException | RuntimeException e) {
                AsyncReconnect reconnect = this.disableReconnects();
                Assert.assertNull(reconnect.getConnectionThread());
                throw e;
            }
        }
        throw new IOException("connection already opened");
    }

    void shutdown() {
        this.quitReconnectAttempts();
        this.transport.close();
    }

    private void setServerAddresses(Iterable<InetSocketAddress> serverAddresses) {
        this.serverAddresses = serverAddresses;
    }

    NetworkStackID connectTryAllOnce(ClientConnectionErrorListener reporter) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.assertFalse(this.transport.isConnected());
        Iterator<InetSocketAddress> serverAddressIterator = this.getServerAddressIterator();
        InetSocketAddress target = null;
        while (target != null || serverAddressIterator.hasNext()) {
            if (target == null) {
                target = ClientConnectionEstablisher.nextServerAddress(serverAddressIterator);
            }
            try {
                return this.transport.open(target);
            }
            catch (TransportRedirect redirect) {
                reporter.onError(target, redirect);
                target = InetSocketAddress.createUnresolved(redirect.getHostname(), redirect.getPort());
                this.redirects.add(target);
            }
            catch (NoActiveException noactive) {
                reporter.onError(target, noactive);
                target = null;
                LOGGER.debug("Connection attempt failed: ", (Throwable)noactive);
                if (serverAddressIterator.hasNext()) continue;
                throw new IOException(noactive);
            }
            catch (TCTimeoutException | IOException e) {
                reporter.onError(target, e);
                target = null;
                if (serverAddressIterator.hasNext()) continue;
                throw e;
            }
        }
        throw new IOException("no connection target available");
    }

    public String toString() {
        return "ClientConnectionEstablisher[" + this.serverAddresses + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect(Supplier<Boolean> stopCheck) throws MaxConnectionsExceededException {
        try {
            LossyTCLogger connectionErrorLossyLogger = new LossyTCLogger(this.transport.getLogger(), 10000L, LossyTCLogger.LossyTCLoggerType.TIME_BASED, true);
            if (!this.transport.getProductID().isReconnectEnabled() && !this.transport.isRetryOnReconnectionRejected()) {
                this.transport.getLogger().info("Got reconnect request for ClientMessageTransport that does not support it.  skipping");
                return;
            }
            this.transport.getLogger().info("reconnecting " + this.transport.getConnectionID());
            boolean connected = this.transport.isConnected();
            boolean reconnectionRejected = false;
            InetSocketAddress target = null;
            int i = 0;
            while (this.tryToConnect(connected, stopCheck)) {
                Iterator<InetSocketAddress> serverAddressIterator = this.getServerAddressIterator();
                while ((target != null || serverAddressIterator.hasNext()) && this.tryToConnect(connected, stopCheck)) {
                    if (reconnectionRejected) {
                        if (this.transport.isRetryOnReconnectionRejected()) {
                            LOGGER.info("Reconnection rejected by L2, trying again to reconnect - " + this.transport);
                        } else {
                            LOGGER.info("Reconnection rejected by L2, no more trying to reconnect - " + this.transport);
                            return;
                        }
                    }
                    if (target == null) {
                        target = ClientConnectionEstablisher.nextServerAddress(serverAddressIterator);
                    }
                    if (i == 0) {
                        String previousConnectHost = "";
                        int previousConnectHostPort = -1;
                        if (this.transport.getRemoteAddress() != null) {
                            previousConnectHost = this.transport.getRemoteAddress().getAddress().getHostAddress();
                            previousConnectHostPort = this.transport.getRemoteAddress().getPort();
                        }
                        String connectingToHost = "";
                        try {
                            connectingToHost = this.getHostByName(target);
                        }
                        catch (UnknownHostException e) {
                            this.handleConnectException(e, true, connectionErrorLossyLogger);
                            target = null;
                            continue;
                        }
                        int connectingToHostPort = target.getPort();
                        if (serverAddressIterator.hasNext() && previousConnectHost.equals(connectingToHost) && previousConnectHostPort == connectingToHostPort) {
                            target = null;
                            continue;
                        }
                    }
                    try {
                        if (i % 20 == 0 && i > 0) {
                            this.transport.getLogger().info("Reconnect attempt " + i + " to " + target);
                        }
                        this.transport.reopen(target);
                        connected = this.transport.isConnected() && this.transport.getConnectionID().isValid();
                    }
                    catch (TransportRedirect redirect) {
                        target = InetSocketAddress.createUnresolved(redirect.getHostname(), redirect.getPort());
                    }
                    catch (NoActiveException noactive) {
                        target = null;
                        this.handleConnectException(new IOException(noactive), false, connectionErrorLossyLogger);
                    }
                    catch (MaxConnectionsExceededException e) {
                        target = null;
                        this.quitReconnectAttempts();
                        throw e;
                    }
                    catch (ReconnectionRejectedException e) {
                        target = null;
                        this.quitReconnectAttempts();
                        reconnectionRejected = true;
                        this.handleConnectException(e, false, connectionErrorLossyLogger);
                    }
                    catch (CommStackMismatchException e) {
                        target = null;
                        this.quitReconnectAttempts();
                        this.handleConnectException(e, false, connectionErrorLossyLogger);
                    }
                    catch (TCTimeoutException e) {
                        target = null;
                        this.handleConnectException(e, false, connectionErrorLossyLogger);
                    }
                    catch (IOException e) {
                        target = null;
                        this.handleConnectException(e, false, connectionErrorLossyLogger);
                    }
                    catch (Exception e) {
                        target = null;
                        this.handleConnectException(e, true, connectionErrorLossyLogger);
                    }
                    catch (Throwable t) {
                        target = null;
                        LOGGER.warn("unknown error", t);
                    }
                }
                ++i;
            }
        }
        finally {
            LOGGER.info("reconnection complete connected:" + this.transport.isConnected());
        }
    }

    private Iterator<InetSocketAddress> getServerAddressIterator() {
        return new CompositeIterator<InetSocketAddress>(Arrays.asList(this.serverAddresses.iterator(), new LinkedHashSet<InetSocketAddress>(this.redirects).iterator()));
    }

    private static InetSocketAddress nextServerAddress(Iterator<InetSocketAddress> serverAddressIterator) {
        InetSocketAddress serverAddress = serverAddressIterator.next();
        if (serverAddress.getPort() <= 0) {
            serverAddress = InetSocketAddress.createUnresolved(serverAddress.getHostString(), 9410);
        }
        return serverAddress;
    }

    String getHostByName(InetSocketAddress serverAddress) throws UnknownHostException {
        return InetAddress.getByName(serverAddress.getHostName()).getHostAddress();
    }

    private boolean tryToConnect(boolean connected, Supplier<Boolean> stopCheck) {
        boolean stopper = stopCheck.get();
        boolean stopped = !this.isReconnectEnabled();
        LOGGER.debug("trying to connect connected:{} stopCheck: {} isStopped: {}", new Object[]{connected, stopper, stopped});
        return !connected && !stopper && !stopped;
    }

    void handleConnectException(Exception e, boolean logFullException, Logger logger) {
        if (logger.isDebugEnabled() || logFullException) {
            logger.error("Connect Exception", (Throwable)e);
        }
        if (CONNECT_RETRY_INTERVAL > 0L) {
            try {
                Thread.sleep(CONNECT_RETRY_INTERVAL);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean asyncReconnect(Supplier<Boolean> stopCheck) {
        if (this.transport.getConnectionID().isValid()) {
            LOGGER.info("async reconnect initiated " + this.transport.getConnectionID());
            return this.putConnectionRequest(ConnectionRequest.newReconnectRequest(stopCheck));
        }
        LOGGER.info("async reconnect ignored connection not valid " + this.transport.getConnectionID());
        this.transport.close();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean putConnectionRequest(ConnectionRequest request) {
        AsyncReconnect reconnect = this.getReconnectHandler();
        if (reconnect == null || reconnect.isStopped()) {
            LOGGER.info("Ignoring connection request: " + request + " as allowReconnects: " + (reconnect == null) + ", asyncReconnect.isStopped(): " + reconnect.isStopped());
            return false;
        }
        if (this.transport != null) {
            if (this.transport.isConnected()) {
                LOGGER.info("Ignoring connection request.  The connection is already open. {}", (Object)this.transport);
                return false;
            } else {
                if (this.transport.wasOpened()) return reconnect.putConnectionRequest(request);
                LOGGER.info("Ignoring connection request as transport was not connected even once");
            }
            return false;
        } else {
            LOGGER.warn("no transport {}", (Object)request);
        }
        return false;
    }

    private synchronized boolean enableReconnects() {
        if (!this.allowReconnects) {
            this.allowReconnects = true;
            Assert.assertTrue(this.asyncReconnect == null);
            this.asyncReconnect = new AsyncReconnect();
            return true;
        }
        return false;
    }

    private synchronized AsyncReconnect disableReconnects() {
        try {
            this.allowReconnects = false;
            AsyncReconnect asyncReconnect = this.asyncReconnect;
            return asyncReconnect;
        }
        finally {
            this.asyncReconnect = null;
        }
    }

    public synchronized boolean isReconnectEnabled() {
        return this.allowReconnects && this.asyncReconnect != null;
    }

    private synchronized AsyncReconnect getReconnectHandler() {
        if (this.allowReconnects) {
            Assert.assertNotNull(this.asyncReconnect);
            return this.asyncReconnect;
        }
        return null;
    }

    private void quitReconnectAttempts() {
        AsyncReconnect reconnect = this.disableReconnects();
        if (reconnect != null) {
            reconnect.stop();
            if (!this.transport.isRetryOnReconnectionRejected()) {
                reconnect.awaitTermination(true);
            }
        }
    }

    void waitForTermination() {
        AsyncReconnect reconnect = this.getReconnectHandler();
        if (reconnect != null) {
            reconnect.waitForThreadToComplete();
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(ClientConnectionEstablisher.class);
        long value = TCPropertiesImpl.getProperties().getLong("l1.socket.reconnect.waitInterval");
        if (value < 1000L) {
            logger.info("Forcing reconnect wait interval to 1000 (configured value was " + value + ")");
            value = 1000L;
        }
        CONNECT_RETRY_INTERVAL = value;
    }

    static class ConnectionRequest {
        private final Supplier<Boolean> stopCheck;

        ConnectionRequest(Supplier<Boolean> stopCheck) {
            this.stopCheck = stopCheck;
        }

        boolean checkForStop() {
            return this.stopCheck.get();
        }

        public static ConnectionRequest newReconnectRequest(Supplier<Boolean> stopCheck) {
            return new ConnectionRequest(stopCheck);
        }
    }

    private class AsyncReconnect {
        private boolean stopped = false;
        private Thread connectionEstablisherThread;

        private AsyncReconnect() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForThread(Thread oldThread, boolean mayInterruptIfRunning) {
            boolean isInterrupted = false;
            try {
                if (oldThread == null) {
                    boolean bl = true;
                    return bl;
                }
                if (Thread.currentThread() != oldThread) {
                    if (mayInterruptIfRunning) {
                        oldThread.interrupt();
                    }
                    oldThread.join();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Got interrupted while waiting for connectionEstablisherThread to complete");
                isInterrupted = true;
            }
            finally {
                Util.selfInterruptIfNeeded(isInterrupted);
            }
            return false;
        }

        private boolean waitForThreadToComplete() {
            return this.waitForThread(this.getConnectionThread(), false);
        }

        private void awaitTermination(boolean mayInterruptIfRunning) {
            Assert.assertTrue(this.isStopped());
            this.waitForThread(this.getConnectionThread(), mayInterruptIfRunning);
        }

        public synchronized boolean isStopped() {
            return this.stopped;
        }

        public synchronized void stop() {
            LOGGER.debug("Connection establisher stopping for connection {} to {}", (Object)ClientConnectionEstablisher.this.transport.getConnectionID(), (Object)ClientConnectionEstablisher.this.serverAddresses);
            this.stopped = true;
            this.notifyAll();
        }

        private synchronized Thread getConnectionThread() {
            return this.connectionEstablisherThread;
        }

        public boolean putConnectionRequest(ConnectionRequest request) {
            if (!this.isStopped() && this.waitForThread(this.getConnectionThread(), true)) {
                if (!ClientConnectionEstablisher.this.transport.isConnected()) {
                    this.startThreadIfNecessary(request);
                    return true;
                }
                LOGGER.info("ignoring connection request.  Already connected: {}", (Object)ClientConnectionEstablisher.this.transport);
            } else {
                LOGGER.info("connect request ignored, already reconnecting");
            }
            return false;
        }

        private synchronized void startThreadIfNecessary(ConnectionRequest request) {
            if (!this.stopped) {
                Thread thread = new Thread(() -> this.execute(request), "ConnectionEstablisher-" + ClientConnectionEstablisher.this.serverAddresses.toString() + "-" + ClientConnectionEstablisher.this.transport.getConnectionID());
                thread.setDaemon(true);
                thread.start();
                LOGGER.info("connection establisher started " + thread.getName());
                this.connectionEstablisherThread = thread;
            }
        }

        public void execute(ConnectionRequest request) {
            block4: {
                LOGGER.info("reconnection starting for connection {} to {}", (Object)ClientConnectionEstablisher.this.transport.getConnectionID(), (Object)ClientConnectionEstablisher.this.serverAddresses);
                if (request != null) {
                    ConnectionIdLogger clientLogger = ClientConnectionEstablisher.this.transport.getLogger();
                    try {
                        ClientConnectionEstablisher.this.reconnect(() -> this.isStopped() || request.checkForStop());
                    }
                    catch (MaxConnectionsExceededException e) {
                        String connInfo = ClientConnectionEstablisher.this.transport == null ? "" : ClientConnectionEstablisher.this.transport.getLocalAddress() + "->" + ClientConnectionEstablisher.this.transport.getRemoteAddress() + " ";
                        ClientConnectionEstablisher.this.transport.getLogger().error(connInfo + e.getMessage());
                    }
                    catch (Throwable t) {
                        if (ClientConnectionEstablisher.this.transport == null) break block4;
                        clientLogger.warn("Reconnect failed !", t);
                    }
                }
            }
            LOGGER.info("reconnection exiting for connection {} to {}", (Object)ClientConnectionEstablisher.this.transport.getConnectionID(), (Object)ClientConnectionEstablisher.this.serverAddresses);
        }
    }
}

