/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.pac4j.core.client.Client;

public class DelegatedAuthenticationAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint auditableTarget, Object retval) {
        Objects.requireNonNull(retval, "Return value must not be null");
        AuditableExecutionResult result = (AuditableExecutionResult)AuditableExecutionResult.class.cast(retval);
        String accessCheckOutcome = "Client Access " + BooleanUtils.toString((boolean)result.isExecutionFailure(), (String)"Denied", (String)"Granted");
        HashMap<String, CallSite> values = new HashMap<String, CallSite>();
        values.put("result", (CallSite)((Object)accessCheckOutcome));
        if (result.getProperties().containsKey(Client.class.getSimpleName())) {
            values.put("client", (CallSite)result.getProperties().get(Client.class.getSimpleName()));
        }
        result.getRegisteredService().ifPresent(service -> values.put("registeredService", (CallSite)((Object)(service.getName() + ":" + service.getServiceId()))));
        result.getService().ifPresent(service -> values.put("service", (CallSite)((Object)service.getId())));
        return new String[]{this.auditFormat.serialize(values)};
    }
}

