/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.PropagationData;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.AttributeDeltaUtil;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class LDAPMembershipPropagationActions
implements PropagationActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipPropagationActions.class);
    @Autowired
    protected DerAttrHandler derAttrHandler;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;

    protected String getGroupMembershipAttrName() {
        return "ldapGroups";
    }

    protected String evaluateGroupConnObjectLink(String connObjectLinkTemplate, Group group) {
        LOG.debug("Evaluating connObjectLink for {}", (Object)group);
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext((Object)group, (JexlContext)jexlContext);
        JexlUtils.addPlainAttrsToContext((Collection)group.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addDerAttrsToContext((Any)group, (DerAttrHandler)this.derAttrHandler, (JexlContext)jexlContext);
        return JexlUtils.evaluateExpr((String)connObjectLinkTemplate, (JexlContext)jexlContext).toString();
    }

    protected void buildManagedGroupConnObjectLinks(ExternalResource resource, String connObjectLinkTemplate, Set<String> connObjectLinks) {
        List managedGroups = this.groupDAO.findByResource(resource);
        managedGroups.forEach(group -> connObjectLinks.add(this.evaluateGroupConnObjectLink(connObjectLinkTemplate, (Group)group)));
    }

    @Transactional(readOnly=true)
    public void before(PropagationTaskInfo taskInfo) {
        if (AnyTypeKind.USER != taskInfo.getAnyTypeKind() || taskInfo.getOperation() == ResourceOperation.DELETE) {
            return;
        }
        taskInfo.getResource().getProvisionByAnyType(AnyTypeKind.GROUP.name()).map(Provision::getMapping).filter(mapping -> StringUtils.isNotBlank((CharSequence)mapping.getConnObjectLink())).ifPresentOrElse(mapping -> {
            User user = (User)this.userDAO.find(taskInfo.getEntityKey());
            HashSet groups = new HashSet();
            this.userDAO.findAllGroupKeys(user).stream().map(arg_0 -> ((GroupDAO)this.groupDAO).find(arg_0)).filter(group -> group.getResources().contains(taskInfo.getResource())).forEach(group -> {
                String groupConnObjectLink = this.evaluateGroupConnObjectLink(mapping.getConnObjectLink(), (Group)group);
                LOG.debug("ConnObjectLink for {} is '{}'", group, (Object)groupConnObjectLink);
                if (StringUtils.isNotBlank((CharSequence)groupConnObjectLink)) {
                    groups.add(groupConnObjectLink);
                }
            });
            LOG.debug("Group connObjectLinks to propagate for membership: {}", groups);
            PropagationData data = taskInfo.getPropagationData();
            Optional.ofNullable(AttributeUtil.find((String)this.getGroupMembershipAttrName(), (Set)data.getAttributes())).ifPresent(ldapGroups -> {
                Optional.ofNullable(ldapGroups.getValue()).ifPresent(value -> value.forEach(obj -> groups.add(obj.toString())));
                data.getAttributes().remove(ldapGroups);
            });
            LOG.debug("Group connObjectLinks after including the ones from mapping: {}", groups);
            taskInfo.getBeforeObj().map(beforeObj -> beforeObj.getAttributeByName(this.getGroupMembershipAttrName())).filter(Objects::nonNull).ifPresent(beforeLdapGroups -> {
                TreeSet<String> connObjectLinks = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                this.buildManagedGroupConnObjectLinks(taskInfo.getResource(), mapping.getConnObjectLink(), connObjectLinks);
                LOG.debug("Memberships not managed by Syncope: {}", beforeLdapGroups);
                beforeLdapGroups.getValue().stream().filter(value -> !connObjectLinks.contains(String.valueOf(value))).forEach(value -> groups.add(String.valueOf(value)));
            });
            LOG.debug("Adding Group connObjectLinks to attributes: {}={}", (Object)this.getGroupMembershipAttrName(), groups);
            data.getAttributes().add(AttributeBuilder.build((String)this.getGroupMembershipAttrName(), groups));
            if (data.getAttributeDeltas() != null && taskInfo.getUpdateRequest() != null) {
                HashSet<String> groupsToAdd = new HashSet<String>();
                HashSet<String> groupsToRemove = new HashSet<String>();
                for (MembershipUR memb : ((UserUR)taskInfo.getUpdateRequest()).getMemberships()) {
                    String connObjectLink = this.evaluateGroupConnObjectLink(mapping.getConnObjectLink(), (Group)this.groupDAO.find(memb.getGroup()));
                    if (memb.getOperation() == PatchOperation.ADD_REPLACE) {
                        groupsToAdd.add(connObjectLink);
                        continue;
                    }
                    groupsToRemove.add(connObjectLink);
                }
                Optional.ofNullable(AttributeDeltaUtil.find((String)this.getGroupMembershipAttrName(), (Set)data.getAttributeDeltas())).ifPresent(ldapGroups -> {
                    Optional.ofNullable(ldapGroups.getValuesToAdd()).ifPresent(value -> value.forEach(obj -> groupsToAdd.add(obj.toString())));
                    Optional.ofNullable(ldapGroups.getValuesToRemove()).ifPresent(value -> value.forEach(obj -> groupsToRemove.add(obj.toString())));
                    data.getAttributeDeltas().remove(ldapGroups);
                });
                if (!groupsToAdd.isEmpty() || !groupsToRemove.isEmpty()) {
                    LOG.debug("Adding Group connObjectLinks to attribute deltas: {}={},{}", new Object[]{this.getGroupMembershipAttrName(), groupsToAdd, groupsToRemove});
                    data.getAttributeDeltas().add(AttributeDeltaBuilder.build((String)this.getGroupMembershipAttrName(), groupsToAdd, groupsToRemove));
                }
            }
        }, () -> LOG.debug("Not about user, or group mapping missing for resource: not doing anything"));
    }
}

