/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceU2FDeviceRepository
extends BaseU2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseResourceU2FDeviceRepository.class);
    public static final String MAP_KEY_DEVICES = "devices";

    protected BaseResourceU2FDeviceRepository(LoadingCache<String, String> requestStorage, CasConfigurationProperties casProperties, CipherExecutor<Serializable, String> cipherExecutor) {
        super(casProperties, requestStorage, cipherExecutor);
    }

    @Override
    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices() {
        try {
            Map<String, List<U2FDeviceRegistration>> devices = this.readDevicesFromResource();
            if (!devices.isEmpty()) {
                List<U2FDeviceRegistration> devs = devices.get(MAP_KEY_DEVICES);
                LocalDate expirationDate = this.getDeviceExpiration();
                LOGGER.debug("Filtering devices for based on device expiration date [{}]", (Object)expirationDate);
                List list = devs.stream().filter(d -> d.getCreatedDate().isAfter(expirationDate)).collect(Collectors.toList());
                LOGGER.debug("There are [{}] device(s) remaining in repository", (Object)list.size());
                return list;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return new ArrayList(0);
    }

    @Override
    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices(String username) {
        try {
            Map<String, List<U2FDeviceRegistration>> devices = this.readDevicesFromResource();
            if (!devices.isEmpty()) {
                List<U2FDeviceRegistration> devs = devices.get(MAP_KEY_DEVICES);
                LocalDate expirationDate = this.getDeviceExpiration();
                LOGGER.debug("Filtering devices for [{}] based on device expiration date [{}]", (Object)username, (Object)expirationDate);
                List list = devs.stream().filter(d -> d.getUsername().equals(username) && d.getCreatedDate().isAfter(expirationDate)).collect(Collectors.toList());
                LOGGER.debug("There are [{}] device(s) remaining in repository for [{}]", (Object)list.size(), (Object)username);
                return list;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return new ArrayList(0);
    }

    @Override
    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration registration) {
        try {
            Map<String, List<U2FDeviceRegistration>> devices = this.readDevicesFromResource();
            ArrayList<U2FDeviceRegistration> list = new ArrayList<U2FDeviceRegistration>(0);
            if (!devices.isEmpty()) {
                List<U2FDeviceRegistration> devs = devices.get(MAP_KEY_DEVICES);
                LOGGER.debug("Located [{}] devices in repository", (Object)devs.size());
                list.addAll(new ArrayList<U2FDeviceRegistration>(devs));
            }
            list.add(registration);
            LOGGER.debug("There are [{}] device(s) remaining in repository. Storing...", (Object)list.size());
            this.writeDevicesBackToResource(list);
            return registration;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isDeviceRegisteredFor(String username) {
        return !this.getRegisteredDevices(username).isEmpty();
    }

    @Override
    public void deleteRegisteredDevice(U2FDeviceRegistration registration) {
        try {
            Map<String, List<U2FDeviceRegistration>> devices = this.readDevicesFromResource();
            if (!devices.isEmpty()) {
                ArrayList<U2FDeviceRegistration> list = new ArrayList<U2FDeviceRegistration>((Collection)devices.get(MAP_KEY_DEVICES));
                LOGGER.debug("Located [{}] devices in repository", (Object)list.size());
                if (list.removeIf(d -> d.getId() == registration.getId() && d.getUsername().equals(registration.getUsername()))) {
                    LOGGER.debug("There are [{}] device(s) remaining in repository. Storing...", (Object)list.size());
                    this.writeDevicesBackToResource(list);
                }
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    @Override
    public void clean() {
        try {
            Map<String, List<U2FDeviceRegistration>> devices = this.readDevicesFromResource();
            if (!devices.isEmpty()) {
                List<U2FDeviceRegistration> devs = devices.get(MAP_KEY_DEVICES);
                LOGGER.debug("Located [{}] devices in repository", (Object)devs.size());
                LocalDate expirationDate = this.getDeviceExpiration();
                LOGGER.debug("Filtering devices based on device expiration date [{}]", (Object)expirationDate);
                List<U2FDeviceRegistration> list = devs.stream().filter(d -> d.getCreatedDate().isAfter(expirationDate)).collect(Collectors.toList());
                LOGGER.debug("There are [{}] device(s) remaining in repository. Storing...", (Object)list.size());
                this.writeDevicesBackToResource(list);
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    protected abstract Map<String, List<U2FDeviceRegistration>> readDevicesFromResource() throws Exception;

    protected abstract void writeDevicesBackToResource(List<U2FDeviceRegistration> var1) throws Exception;
}

