/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseU2FDeviceRepository
implements U2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseU2FDeviceRepository.class);
    protected final CasConfigurationProperties casProperties;
    private final LoadingCache<String, String> requestStorage;
    private final CipherExecutor<Serializable, String> cipherExecutor;

    @Override
    public String getDeviceRegistrationRequest(String requestId, String username) {
        String request = (String)this.requestStorage.get((Object)requestId);
        this.requestStorage.invalidate((Object)requestId);
        this.requestStorage.cleanUp();
        return request;
    }

    @Override
    public String getDeviceAuthenticationRequest(String requestId, String username) {
        String request = (String)this.requestStorage.get((Object)requestId);
        this.requestStorage.invalidate((Object)requestId);
        this.requestStorage.cleanUp();
        return request;
    }

    @Override
    public void requestDeviceRegistration(String requestId, String username, String registrationJsonData) {
        this.requestStorage.put((Object)requestId, (Object)registrationJsonData);
    }

    @Override
    public void requestDeviceAuthentication(String requestId, String username, String registrationJsonData) {
        this.requestStorage.put((Object)requestId, (Object)registrationJsonData);
    }

    @Override
    public U2FDeviceRegistration verifyRegisteredDevice(U2FDeviceRegistration registration) {
        Collection<? extends U2FDeviceRegistration> devices = this.getRegisteredDevices(registration.getUsername());
        U2FDeviceRegistration decoded = this.decode(registration);
        LOGGER.trace("Located devices [{}] for username [{}]", devices, (Object)registration.getUsername());
        boolean matched = devices.stream().map(this::decode).anyMatch(device -> device.matches(decoded));
        if (!matched) {
            throw new AuthenticationException("Failed to authenticate U2F device because no matching record was found. Is the device registered?");
        }
        return registration;
    }

    protected LocalDate getDeviceExpiration() {
        long expiration = this.casProperties.getAuthn().getMfa().getU2f().getCore().getExpireDevices();
        TimeUnit expirationTimeUnit = this.casProperties.getAuthn().getMfa().getU2f().getCore().getExpireDevicesTimeUnit();
        return LocalDate.now(ZoneId.systemDefault()).minus(expiration, DateTimeUtils.toChronoUnit((TimeUnit)expirationTimeUnit));
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public LoadingCache<String, String> getRequestStorage() {
        return this.requestStorage;
    }

    @Override
    @Generated
    public CipherExecutor<Serializable, String> getCipherExecutor() {
        return this.cipherExecutor;
    }

    @Generated
    protected BaseU2FDeviceRepository(CasConfigurationProperties casProperties, LoadingCache<String, String> requestStorage, CipherExecutor<Serializable, String> cipherExecutor) {
        this.casProperties = casProperties;
        this.requestStorage = requestStorage;
        this.cipherExecutor = cipherExecutor;
    }
}

