/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;

public class OAuth20HandlerInterceptorAdapter
implements AsyncHandlerInterceptor {
    protected final ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor;
    protected final ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor;
    private final ObjectProvider<List<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors;
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<SessionStore> sessionStore;
    private final ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthAuthorizationRequestValidators;
    private final ObjectProvider<OAuth20RequestParameterResolver> requestParameterResolver;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.requestRequiresAuthentication(request, response)) {
            return ((HandlerInterceptor)this.requiresAuthenticationAccessTokenInterceptor.getObject()).preHandle(request, response, handler);
        }
        if (this.isDeviceTokenRequest(request, response)) {
            return ((HandlerInterceptor)this.requiresAuthenticationAuthorizeInterceptor.getObject()).preHandle(request, response, handler);
        }
        return !this.isAuthorizationRequest(request, response) || ((HandlerInterceptor)this.requiresAuthenticationAuthorizeInterceptor.getObject()).preHandle(request, response, handler);
    }

    protected boolean clientNeedAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String clientId = (String)((OAuth20RequestParameterResolver)this.requestParameterResolver.getObject()).resolveClientIdAndClientSecret((WebContext)new JEEContext(request, response), (SessionStore)this.sessionStore.getObject()).getLeft();
        if (clientId.isEmpty()) {
            return true;
        }
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager.getObject(), clientId);
        return registeredService == null || OAuth20Utils.doesServiceNeedAuthentication(registeredService);
    }

    protected boolean isRevokeTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestPath = request.getRequestURI();
        return this.doesUriMatchPattern(requestPath, this.getRevocationUrls());
    }

    protected List<String> getRevocationUrls() {
        return CollectionUtils.wrapList((Object[])new String[]{"revoke"});
    }

    protected boolean isAccessTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestPath = request.getRequestURI();
        return this.doesUriMatchPattern(requestPath, this.getAccessTokenUrls());
    }

    protected List<String> getAccessTokenUrls() {
        return CollectionUtils.wrapList((Object[])new String[]{"accessToken", "token"});
    }

    protected boolean isDeviceTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        String requestPath = request.getRequestURI();
        return this.doesUriMatchPattern(requestPath, CollectionUtils.wrapList((Object[])new String[]{"device"}));
    }

    protected boolean requestRequiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        JEEContext context = new JEEContext(request, response);
        boolean revokeTokenRequest = this.isRevokeTokenRequest(request, response);
        if (revokeTokenRequest) {
            return this.clientNeedAuthentication(request, response);
        }
        boolean accessTokenRequest = this.isAccessTokenRequest(request, response);
        Optional<AccessTokenGrantRequestExtractor> extractor = this.extractAccessTokenGrantRequest((WebContext)context);
        if (!accessTokenRequest) {
            if (extractor.isPresent()) {
                AccessTokenGrantRequestExtractor ext = extractor.get();
                return ext.requestMustBeAuthenticated();
            }
        } else if (extractor.isPresent()) {
            AccessTokenGrantRequestExtractor ext = extractor.get();
            return ext.getResponseType() != OAuth20ResponseTypes.DEVICE_CODE;
        }
        return false;
    }

    protected boolean isAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext context = new JEEContext(request, response);
        String requestPath = request.getRequestURI();
        return this.doesUriMatchPattern(requestPath, this.getAuthorizeUrls()) && this.isValidAuthorizeRequest(context);
    }

    protected List<String> getAuthorizeUrls() {
        return CollectionUtils.wrapList((Object[])new String[]{"authorize"});
    }

    protected boolean doesUriMatchPattern(String requestPath, List<String> patternUrls) {
        return patternUrls.stream().anyMatch(patternUrl -> {
            Pattern pattern = Pattern.compile("/" + patternUrl + "(/)*$");
            return pattern.matcher(requestPath).find();
        });
    }

    protected boolean isValidAuthorizeRequest(JEEContext context) throws Exception {
        OAuth20AuthorizationRequestValidator validator = ((List)this.oauthAuthorizationRequestValidators.getObject()).stream().filter(BeanSupplier::isNotProxy).filter(Unchecked.predicate(b -> b.supports((WebContext)context))).findFirst().orElse(null);
        return validator != null && validator.validate((WebContext)context);
    }

    private Optional<AccessTokenGrantRequestExtractor> extractAccessTokenGrantRequest(WebContext context) {
        return ((List)this.accessTokenGrantRequestExtractors.getObject()).stream().filter(BeanSupplier::isNotProxy).filter(ext -> ext.supports(context)).findFirst();
    }

    @Generated
    public OAuth20HandlerInterceptorAdapter(ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor, ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor, ObjectProvider<List<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<SessionStore> sessionStore, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthAuthorizationRequestValidators, ObjectProvider<OAuth20RequestParameterResolver> requestParameterResolver) {
        this.requiresAuthenticationAccessTokenInterceptor = requiresAuthenticationAccessTokenInterceptor;
        this.requiresAuthenticationAuthorizeInterceptor = requiresAuthenticationAuthorizeInterceptor;
        this.accessTokenGrantRequestExtractors = accessTokenGrantRequestExtractors;
        this.servicesManager = servicesManager;
        this.sessionStore = sessionStore;
        this.oauthAuthorizationRequestValidators = oauthAuthorizationRequestValidators;
        this.requestParameterResolver = requestParameterResolver;
    }
}

