/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.File;
import org.apache.openjpa.jdbc.conf.JDBCSeqValue;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.SequenceMetaData;

public class SequenceMapping
extends SequenceMetaData {
    private static final long serialVersionUID = 1L;
    public static final String IMPL_VALUE_TABLE = "value-table";
    public static final String IMPL_TABLE = "table";
    public static final String IMPL_CLASS_TABLE = "class-table";
    private static final String PROP_TABLE = "Table";
    private static final String PROP_SEQUENCE_COL = "SequenceColumn";
    private static final String PROP_PK_COL = "PrimaryKeyColumn";
    private static final String PROP_PK_VALUE = "PrimaryKeyValue";
    private static final String PROP_UNIQUE = "UniqueColumns";
    private static final String PROP_UNIQUE_CONSTRAINT = "UniqueConstraintName";
    private File _mapFile = null;
    private DBIdentifier _table = DBIdentifier.NULL;
    private DBIdentifier _sequenceColumn = DBIdentifier.NULL;
    private DBIdentifier _primaryKeyColumn = DBIdentifier.NULL;
    private String _primaryKeyValue = null;
    private DBIdentifier[] _uniqueColumns = null;
    private DBIdentifier _uniqueConstraintName = DBIdentifier.NULL;

    @Deprecated
    public SequenceMapping(String name, MappingRepository repos) {
        super(name, (MetaDataRepository)repos);
    }

    public SequenceMapping(DBIdentifier name, MappingRepository repos) {
        super(DBIdentifier.isNull(name) ? null : name.getName(), (MetaDataRepository)repos);
    }

    public File getMappingFile() {
        return this._mapFile;
    }

    public void setMappingFile(File file) {
        this._mapFile = file;
    }

    @Deprecated
    public String getTable() {
        return this.getTableIdentifier().getName();
    }

    public DBIdentifier getTableIdentifier() {
        return this._table == null ? DBIdentifier.NULL : this._table;
    }

    @Deprecated
    public void setTable(String table) {
        this.setTableIdentifier(DBIdentifier.newTable(table));
    }

    public void setTableIdentifier(DBIdentifier table) {
        this._table = table;
    }

    @Deprecated
    public String getSequenceColumn() {
        return this.getSequenceColumnIdentifier().getName();
    }

    public DBIdentifier getSequenceColumnIdentifier() {
        return this._sequenceColumn == null ? DBIdentifier.NULL : this._sequenceColumn;
    }

    @Deprecated
    public void setSequenceColumn(String sequenceColumn) {
        this.setSequenceColumnIdentifier(DBIdentifier.newColumn(sequenceColumn));
    }

    public void setSequenceColumnIdentifier(DBIdentifier sequenceColumn) {
        this._sequenceColumn = sequenceColumn;
    }

    @Deprecated
    public String getPrimaryKeyColumn() {
        return this.getPrimaryKeyColumnIdentifier().getName();
    }

    public DBIdentifier getPrimaryKeyColumnIdentifier() {
        return this._primaryKeyColumn == null ? DBIdentifier.NULL : this._primaryKeyColumn;
    }

    @Deprecated
    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this.setPrimaryKeyColumnIdentifier(DBIdentifier.newColumn(primaryKeyColumn));
    }

    public void setPrimaryKeyColumnIdentifier(DBIdentifier primaryKeyColumn) {
        this._primaryKeyColumn = primaryKeyColumn;
    }

    public String getPrimaryKeyValue() {
        return this._primaryKeyValue;
    }

    public void setPrimaryKeyValue(String primaryKeyValue) {
        this._primaryKeyValue = primaryKeyValue;
    }

    @Deprecated
    public void setUniqueColumns(String[] cols) {
        this.setUniqueColumnsIdentifier(DBIdentifier.toArray(cols, DBIdentifier.DBIdentifierType.COLUMN));
    }

    public void setUniqueColumnsIdentifier(DBIdentifier[] cols) {
        this._uniqueColumns = cols;
    }

    @Deprecated
    public String[] getUniqueColumns() {
        return DBIdentifier.toStringArray(this.getUniqueColumnsIdentifier());
    }

    public DBIdentifier[] getUniqueColumnsIdentifier() {
        return this._uniqueColumns;
    }

    protected PluginValue newPluginValue(String property) {
        return new JDBCSeqValue(property);
    }

    protected void addStandardProperties(StringBuilder props) {
        super.addStandardProperties(props);
        this.appendProperty(props, PROP_TABLE, this.addQuotes(this._table.getName()));
        this.appendProperty(props, PROP_SEQUENCE_COL, this.addQuotes(this._sequenceColumn.getName()));
        this.appendProperty(props, PROP_PK_COL, this.addQuotes(this._primaryKeyColumn.getName()));
        this.appendProperty(props, PROP_PK_VALUE, this.addQuotes(this._primaryKeyValue));
        if (!DBIdentifier.isNull(this._uniqueConstraintName) && this._uniqueConstraintName.getName().length() > 0) {
            this.appendProperty(props, PROP_UNIQUE_CONSTRAINT, this.addQuotes(this._uniqueConstraintName.getName()));
        }
        if (this._uniqueColumns != null && this._uniqueColumns.length > 0) {
            this.appendProperty(props, PROP_UNIQUE, StringUtil.join((Object[])this._uniqueColumns, (String)"|"));
        }
    }

    private String addQuotes(String name) {
        if (name != null && name.contains("\"")) {
            return "\"" + name + "\"";
        }
        return name;
    }

    @Deprecated
    public void setUniqueConstraintName(String name) {
        this._uniqueConstraintName = DBIdentifier.newConstraint(name);
    }

    public void setUniqueConstraintIdentifier(DBIdentifier name) {
        this._uniqueConstraintName = name;
    }

    @Deprecated
    public String getUniqueConstraintName() {
        return this.getUniqueConstraintIdentifier().getName();
    }

    public DBIdentifier getUniqueConstraintIdentifier() {
        return this._uniqueConstraintName == null ? DBIdentifier.NULL : this._uniqueConstraintName;
    }
}

