/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogatePrincipal;
import org.apereo.cas.authentication.attribute.PrincipalAttributeRepositoryFetcher;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.services.persondir.IPersonAttributeDao;

public class SurrogatePrincipalBuilder {
    private final PrincipalFactory principalFactory;
    private final IPersonAttributeDao attributeRepository;
    private final SurrogateAuthenticationService surrogateAuthenticationService;

    public Principal buildSurrogatePrincipal(String surrogate, Principal primaryPrincipal, RegisteredService registeredService) {
        HashSet repositories = new HashSet(0);
        if (registeredService != null) {
            repositories.addAll(registeredService.getAttributeReleasePolicy().getPrincipalAttributesRepository().getAttributeRepositoryIds());
        }
        Map attributes = PrincipalAttributeRepositoryFetcher.builder().attributeRepository(this.attributeRepository).principalId(surrogate).activeAttributeRepositoryIdentifiers(repositories).currentPrincipal(primaryPrincipal).build().retrieve();
        Principal principal = this.principalFactory.createPrincipal(surrogate, attributes);
        return new SurrogatePrincipal(primaryPrincipal, principal);
    }

    public Principal buildSurrogatePrincipal(String surrogate, Principal primaryPrincipal) {
        return this.buildSurrogatePrincipal(surrogate, primaryPrincipal, null);
    }

    public Optional<AuthenticationResultBuilder> buildSurrogateAuthenticationResult(AuthenticationResultBuilder authenticationResultBuilder, Credential credential, String surrogateTargetId, RegisteredService registeredService) {
        Optional currentAuthn = authenticationResultBuilder.getInitialAuthentication();
        if (currentAuthn.isPresent()) {
            Authentication authentication = (Authentication)currentAuthn.get();
            Principal principal = authentication.getPrincipal();
            if (authentication.getPrincipal() instanceof SurrogatePrincipal) {
                principal = ((SurrogatePrincipal)SurrogatePrincipal.class.cast(authentication.getPrincipal())).getPrimary();
            }
            if (!this.surrogateAuthenticationService.canImpersonate(surrogateTargetId, principal, Optional.empty())) {
                throw new SurrogateAuthenticationException("Unable to authorize surrogate authentication request for " + surrogateTargetId);
            }
            Principal surrogatePrincipal = this.buildSurrogatePrincipal(surrogateTargetId, principal, registeredService);
            Authentication auth = DefaultAuthenticationBuilder.newInstance((Authentication)authentication).setPrincipal(surrogatePrincipal).build();
            return Optional.of(authenticationResultBuilder.collect(auth));
        }
        return Optional.empty();
    }

    @Generated
    public SurrogatePrincipalBuilder(PrincipalFactory principalFactory, IPersonAttributeDao attributeRepository, SurrogateAuthenticationService surrogateAuthenticationService) {
        this.principalFactory = principalFactory;
        this.attributeRepository = attributeRepository;
        this.surrogateAuthenticationService = surrogateAuthenticationService;
    }
}

