/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.BaseSurrogateAuthenticationService;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSurrogateAuthenticationService
extends BaseSurrogateAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSurrogateAuthenticationService.class);
    private final Map<String, List> eligibleAccounts;

    public SimpleSurrogateAuthenticationService(Map<String, List> eligibleAccounts, ServicesManager servicesManager) {
        super(servicesManager);
        this.eligibleAccounts = eligibleAccounts;
    }

    @Override
    public boolean canImpersonateInternal(String surrogate, Principal principal, Optional<Service> service) {
        if (this.eligibleAccounts.containsKey(principal.getId())) {
            List surrogates = this.eligibleAccounts.get(principal.getId());
            LOGGER.debug("Surrogate accounts authorized for [{}] are [{}]", (Object)principal.getId(), (Object)surrogates);
            return surrogates.contains(surrogate);
        }
        LOGGER.warn("[{}] is not eligible to authenticate as [{}]", (Object)principal.getId(), (Object)surrogate);
        return false;
    }

    public Collection<String> getImpersonationAccounts(String username) {
        if (this.eligibleAccounts.containsKey(username)) {
            return this.eligibleAccounts.get(username);
        }
        return new ArrayList<String>(0);
    }

    @Generated
    public Map<String, List> getEligibleAccounts() {
        return this.eligibleAccounts;
    }
}

