/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class AzureConnectorConfiguration
extends AbstractConfiguration
implements StatefulConfiguration {
    public static final String DEFAULT_RESOURCE_URI = "https://graph.windows.net";
    private String clientId;
    private String authority;
    private String redirectURI = "https://login.live.com/oauth20_desktop.srf";
    private String resourceURI = "https://graph.windows.net";
    private String username;
    private String password;
    private String domain;
    private String tenantId;
    private String clientSecret;
    private String scopes = "https://graph.microsoft.com/.default";
    private String[] userAttributesToGet = new String[]{"userPrincipalName", "id"};
    private String[] groupAttributesToGet = new String[]{"id", "mailEnabled", "securityEnabled"};
    private boolean restoreItems;

    @ConfigurationProperty(order=1, displayMessageKey="clientId.display", helpMessageKey="clientId.help", required=true)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ConfigurationProperty(order=2, displayMessageKey="authority.display", helpMessageKey="authority.help", required=true)
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    @ConfigurationProperty(order=3, displayMessageKey="redirectURI.display", helpMessageKey="redirectURI.help")
    public String getRedirectURI() {
        return this.redirectURI;
    }

    public void setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
    }

    @ConfigurationProperty(order=4, displayMessageKey="resourceURI.display", helpMessageKey="resourceURI.help")
    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    @ConfigurationProperty(order=5, displayMessageKey="username.display", helpMessageKey="username.help", required=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @ConfigurationProperty(order=6, displayMessageKey="password.display", helpMessageKey="password.help", required=true, confidential=true)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ConfigurationProperty(order=7, displayMessageKey="domain.display", helpMessageKey="domain.help", required=true)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @ConfigurationProperty(order=8, displayMessageKey="tenantId.display", helpMessageKey="tenantId.help", required=true)
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @ConfigurationProperty(order=9, displayMessageKey="clientSecret.display", helpMessageKey="clientSecret.help", required=true)
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @ConfigurationProperty(order=10, displayMessageKey="scopes.display", helpMessageKey="scopes.help", required=true)
    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    @ConfigurationProperty(order=11, displayMessageKey="userAttributesToGet.display", helpMessageKey="userAttributesToGet.help", required=true)
    public String[] getUserAttributesToGet() {
        return this.userAttributesToGet;
    }

    public void setUserAttributesToGet(String ... userAttributesToGet) {
        this.userAttributesToGet = (String[])userAttributesToGet.clone();
    }

    @ConfigurationProperty(order=12, displayMessageKey="groupAttributesToGet.display", helpMessageKey="groupAttributesToGet.help", required=true)
    public String[] getGroupAttributesToGet() {
        return this.groupAttributesToGet;
    }

    public void setGroupAttributesToGet(String ... groupAttributesToGet) {
        this.groupAttributesToGet = (String[])groupAttributesToGet.clone();
    }

    @ConfigurationProperty(order=13, displayMessageKey="restoreItems.display", helpMessageKey="restoreItems.help")
    public boolean getRestoreItems() {
        return this.restoreItems;
    }

    public void setRestoreItems(boolean restoreItems) {
        this.restoreItems = restoreItems;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.authority)) {
            throw new IllegalArgumentException("Authority cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.clientId)) {
            throw new IllegalArgumentException("Client Id cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.username)) {
            throw new IllegalArgumentException("Username cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.password)) {
            throw new IllegalArgumentException("Password Id cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.domain)) {
            throw new IllegalArgumentException("Domain Id cannot be null or empty.");
        }
    }

    public void release() {
    }
}

