/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GeneratedPassword
implements Serializable {
    private static final byte TYPE_VALIDATION_ERRORS = -96;
    private static final long serialVersionUID = -240847847799966594L;
    @NotNull
    private final ASN1OctetString password;
    private final boolean validationAttempted;
    @NotNull
    private final List<String> validationErrors;

    public GeneratedPassword(@NotNull String password, boolean validationAttempted, @Nullable List<String> validationErrors) {
        this(new ASN1OctetString(password), validationAttempted, validationErrors);
    }

    public GeneratedPassword(@NotNull byte[] password, boolean validationAttempted, @Nullable List<String> validationErrors) {
        this(new ASN1OctetString(password), validationAttempted, validationErrors);
    }

    private GeneratedPassword(@NotNull ASN1OctetString password, boolean validationAttempted, @Nullable List<String> validationErrors) {
        Validator.ensureTrue(password != null && password.getValueLength() > 0, "GeneratedPassword.password must not be null or empty.");
        this.password = password;
        this.validationAttempted = validationAttempted;
        this.validationErrors = validationErrors == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(validationErrors));
    }

    @NotNull
    public String getPasswordString() {
        return this.password.stringValue();
    }

    @NotNull
    public byte[] getPasswordBytes() {
        return this.password.getValue();
    }

    public boolean validationAttempted() {
        return this.validationAttempted;
    }

    @NotNull
    public List<String> getValidationErrors() {
        return this.validationErrors;
    }

    @NotNull
    public ASN1Sequence encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(this.password);
        elements.add(new ASN1Boolean(this.validationAttempted));
        if (!this.validationErrors.isEmpty()) {
            ArrayList<ASN1OctetString> validationErrorElements = new ArrayList<ASN1OctetString>(this.validationErrors.size());
            for (String error : this.validationErrors) {
                validationErrorElements.add(new ASN1OctetString(error));
            }
            elements.add(new ASN1Sequence(-96, validationErrorElements));
        }
        return new ASN1Sequence(elements);
    }

    @NotNull
    public static GeneratedPassword decode(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            ASN1OctetString password = elements[0].decodeAsOctetString();
            boolean validationAttempted = elements[1].decodeAsBoolean().booleanValue();
            ArrayList<String> validationErrors = new ArrayList<String>(5);
            for (int i = 2; i < elements.length; ++i) {
                if (elements[i].getType() != -96) continue;
                for (ASN1Element errorElement : elements[i].decodeAsSequence().elements()) {
                    validationErrors.add(errorElement.decodeAsOctetString().stringValue());
                }
            }
            return new GeneratedPassword(password, validationAttempted, validationErrors);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GENERATED_PASSWORD_DECODING_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GeneratedPassword(passwordLength=");
        buffer.append(this.password.getValueLength());
        buffer.append(", validationAttempted=");
        buffer.append(this.validationAttempted);
        if (!this.validationErrors.isEmpty()) {
            buffer.append(", validationErrors={");
            buffer.append('}');
        }
        buffer.append(')');
    }
}

