/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapUtils;
import org.ldaptive.beans.AttributeValueMutator;
import org.ldaptive.beans.ClassDescriptor;
import org.ldaptive.beans.DnValueMutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassDescriptor
implements ClassDescriptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AttributeValueMutator> attributeMutators = new LinkedHashMap<String, AttributeValueMutator>();
    private DnValueMutator dnMutator;

    protected void setDnValueMutator(DnValueMutator mutator) {
        if (this.dnMutator != null) {
            throw new IllegalStateException("Found duplicate dn");
        }
        this.dnMutator = mutator;
    }

    protected void addAttributeValueMutator(AttributeValueMutator mutator) {
        if (this.attributeMutators.containsKey(mutator.getName())) {
            throw new IllegalStateException("Found duplicate attribute name '" + mutator.getName() + "'");
        }
        this.attributeMutators.put(mutator.getName(), mutator);
    }

    protected void addAttributeValueMutator(Collection<AttributeValueMutator> mutators) {
        mutators.forEach(this::addAttributeValueMutator);
    }

    @Override
    public DnValueMutator getDnValueMutator() {
        return this.dnMutator;
    }

    @Override
    public Collection<AttributeValueMutator> getAttributeValueMutators() {
        return this.attributeMutators.values();
    }

    @Override
    public AttributeValueMutator getAttributeValueMutator(String name) {
        return this.attributeMutators.get(name);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "dnMutator=" + this.dnMutator + ", " + "attributeMutators=" + this.attributeMutators + "]";
    }

    protected static class SimpleAttributeValueMutator
    implements AttributeValueMutator {
        private final LdapAttribute la = new LdapAttribute();

        public SimpleAttributeValueMutator(String name, String[] values, boolean binary) {
            this.la.setBinary(binary);
            this.la.setName(name);
            if (binary) {
                for (String value : values) {
                    this.la.addBinaryValues((byte[][])new byte[][]{LdapUtils.base64Decode((String)value)});
                }
            } else {
                this.la.addStringValues(values);
            }
        }

        @Override
        public String getName() {
            return this.la.getName();
        }

        @Override
        public boolean isBinary() {
            return this.la.isBinary();
        }

        @Override
        public Collection<String> getStringValues(Object object) {
            return this.la.getStringValues();
        }

        @Override
        public Collection<byte[]> getBinaryValues(Object object) {
            return this.la.getBinaryValues();
        }

        @Override
        public void setStringValues(Object object, Collection<String> values) {
        }

        @Override
        public void setBinaryValues(Object object, Collection<byte[]> values) {
        }

        public String toString() {
            return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "ldapAttribute=" + this.la + "]";
        }
    }

    protected static class SimpleDnValueMutator
    implements DnValueMutator {
        private final String dn;

        public SimpleDnValueMutator(String value) {
            this.dn = value;
        }

        @Override
        public String getValue(Object object) {
            return this.dn;
        }

        @Override
        public void setValue(Object object, String value) {
        }
    }
}

