/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.services.util.RegisteredServiceYamlSerializer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.feature.CasRuntimeModuleLoader;
import org.apereo.cas.util.spring.DirectObjectProvider;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.report.AuditLogEndpoint;
import org.apereo.cas.web.report.CasFeaturesEndpoint;
import org.apereo.cas.web.report.CasInfoEndpointContributor;
import org.apereo.cas.web.report.CasReleaseAttributesReportEndpoint;
import org.apereo.cas.web.report.CasResolveAttributesReportEndpoint;
import org.apereo.cas.web.report.CasRuntimeModulesEndpoint;
import org.apereo.cas.web.report.RegisteredAuthenticationHandlersEndpoint;
import org.apereo.cas.web.report.RegisteredAuthenticationPoliciesEndpoint;
import org.apereo.cas.web.report.RegisteredServicesEndpoint;
import org.apereo.cas.web.report.SingleSignOnSessionStatusEndpoint;
import org.apereo.cas.web.report.SingleSignOnSessionsEndpoint;
import org.apereo.cas.web.report.SpringWebflowEndpoint;
import org.apereo.cas.web.report.StatisticsEndpoint;
import org.apereo.cas.web.report.StatusEndpoint;
import org.apereo.cas.web.report.TicketExpirationPoliciesEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.trace.http.HttpTraceEndpoint;
import org.springframework.boot.actuate.trace.http.HttpTraceRepository;
import org.springframework.boot.actuate.trace.http.InMemoryHttpTraceRepository;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Reports)
@AutoConfiguration
public class CasReportsConfiguration {
    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasFeaturesEndpoint casFeaturesEndpoint(CasConfigurationProperties casProperties) {
        return new CasFeaturesEndpoint(casProperties);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public SpringWebflowEndpoint springWebflowEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        return new SpringWebflowEndpoint(casProperties, (ApplicationContext)applicationContext);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuditLogEndpoint auditLogEndpoint(@Qualifier(value="auditTrailExecutionPlan") ObjectProvider<AuditTrailExecutionPlan> auditTrailExecutionPlan, CasConfigurationProperties casProperties) {
        return new AuditLogEndpoint(auditTrailExecutionPlan, casProperties);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasRuntimeModulesEndpoint casRuntimeModulesEndpoint(@Qualifier(value="casRuntimeModuleLoader") ObjectProvider<CasRuntimeModuleLoader> casRuntimeModuleLoader, CasConfigurationProperties casProperties) {
        return new CasRuntimeModulesEndpoint(casProperties, casRuntimeModuleLoader);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RegisteredServicesEndpoint registeredServicesReportEndpoint(ObjectProvider<ConfigurableApplicationContext> applicationContext, @Qualifier(value="webApplicationServiceFactory") ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, CasConfigurationProperties casProperties) {
        List serializers = CollectionUtils.wrapList((Object[])new RegisteredServiceJsonSerializer[]{new RegisteredServiceYamlSerializer((ConfigurableApplicationContext)applicationContext.getObject()), new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext.getObject())});
        return new RegisteredServicesEndpoint(casProperties, servicesManager, webApplicationServiceFactory, (ObjectProvider)new DirectObjectProvider((Object)serializers), applicationContext);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RegisteredAuthenticationHandlersEndpoint registeredAuthenticationHandlersEndpoint(@Qualifier(value="authenticationEventExecutionPlan") ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan, CasConfigurationProperties casProperties) {
        return new RegisteredAuthenticationHandlersEndpoint(casProperties, authenticationEventExecutionPlan);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RegisteredAuthenticationPoliciesEndpoint registeredAuthenticationPoliciesEndpoint(@Qualifier(value="authenticationEventExecutionPlan") ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan, CasConfigurationProperties casProperties) {
        return new RegisteredAuthenticationPoliciesEndpoint(casProperties, authenticationEventExecutionPlan);
    }

    @Bean
    @ConditionalOnMissingBean(name={"casInfoEndpointContributor"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasInfoEndpointContributor casInfoEndpointContributor(@Qualifier(value="casRuntimeModuleLoader") CasRuntimeModuleLoader casRuntimeModuleLoader) {
        return new CasInfoEndpointContributor(casRuntimeModuleLoader);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public SingleSignOnSessionsEndpoint singleSignOnSessionsEndpoint(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultSingleLogoutRequestExecutor") ObjectProvider<SingleLogoutRequestExecutor> defaultSingleLogoutRequestExecutor, CasConfigurationProperties casProperties) {
        return new SingleSignOnSessionsEndpoint(ticketRegistry, casProperties, defaultSingleLogoutRequestExecutor);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public SingleSignOnSessionStatusEndpoint singleSignOnSessionStatusEndpoint(@Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
        return new SingleSignOnSessionStatusEndpoint(ticketGrantingTicketCookieGenerator, ticketRegistrySupport);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public StatisticsEndpoint statisticsReportEndpoint(@Qualifier(value="ticketRegistry") ObjectProvider<TicketRegistry> ticketRegistry, @Qualifier(value="centralAuthenticationService") ObjectProvider<CentralAuthenticationService> centralAuthenticationService, CasConfigurationProperties casProperties) {
        return new StatisticsEndpoint(ticketRegistry, casProperties);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasResolveAttributesReportEndpoint resolveAttributesReportEndpoint(@Qualifier(value="defaultPrincipalResolver") ObjectProvider<PrincipalResolver> defaultPrincipalResolver, CasConfigurationProperties casProperties) {
        return new CasResolveAttributesReportEndpoint(casProperties, defaultPrincipalResolver);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnAvailableEndpoint
    public TicketExpirationPoliciesEndpoint ticketExpirationPoliciesEndpoint(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, List<ExpirationPolicyBuilder> builders) {
        return new TicketExpirationPoliciesEndpoint(casProperties, builders, servicesManager, webApplicationServiceFactory);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnAvailableEndpoint(endpoint=HttpTraceEndpoint.class)
    public HttpTraceRepository httpTraceRepository() {
        return new InMemoryHttpTraceRepository();
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasReleaseAttributesReportEndpoint releaseAttributesReportEndpoint(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="principalFactory") PrincipalFactory principalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        return new CasReleaseAttributesReportEndpoint(casProperties, servicesManager, authenticationSystemSupport, webApplicationServiceFactory, principalFactory);
    }

    @Configuration(value="StatusEndpointConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Deprecated(since="6.2.0")
    public static class StatusEndpointConfiguration {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(StatusEndpointConfiguration.class);

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public StatusEndpoint statusEndpoint(ObjectProvider<HealthEndpoint> healthEndpoint, CasConfigurationProperties casProperties) {
            return new StatusEndpoint(casProperties, healthEndpoint);
        }

        @Bean
        @ConditionalOnAvailableEndpoint(endpoint=StatusEndpoint.class)
        public InitializingBean statusEndpointInitializer() {
            return () -> LOGGER.warn("The status actuator endpoint is deprecated and is scheduled to be removed from CAS in the future. To obtain status and health information, please configure and use the health endpoint instead.");
        }
    }
}

