/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitPasswordResetAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitPasswordResetAction.class);
    private final PasswordManagementService passwordManagementService;

    protected Event doExecute(RequestContext requestContext) {
        String token = PasswordManagementWebflowUtils.getPasswordResetToken(requestContext);
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.error("Password reset token is missing");
            return this.error();
        }
        String username = this.passwordManagementService.parseToken(token);
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.error("Password reset token could not be verified to determine username");
            return this.error();
        }
        UsernamePasswordCredential c = new UsernamePasswordCredential();
        c.setUsername(username);
        WebUtils.putCredential((RequestContext)requestContext, (Credential)c);
        return this.success();
    }

    @Generated
    public InitPasswordResetAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }
}

