/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementAction;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifyPasswordResetRequestAction
extends BasePasswordManagementAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyPasswordResetRequestAction.class);
    public static final String EVENT_ID_SECURITY_QUESTIONS_DISABLED = "questionsDisabled";
    private final CasConfigurationProperties casProperties;
    private final PasswordManagementService passwordManagementService;
    private final TicketRegistry ticketRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String transientTicket = request.getParameter("pswdrst");
        if (StringUtils.isBlank((CharSequence)transientTicket)) {
            LOGGER.error("Password reset token is missing");
            return this.error();
        }
        TransientSessionTicket passwordResetTicket = null;
        try {
            Event event;
            passwordResetTicket = (TransientSessionTicket)this.ticketRegistry.getTicket(transientTicket, TransientSessionTicket.class);
            passwordResetTicket.update();
            this.ticketRegistry.updateTicket((Ticket)passwordResetTicket);
            String token = passwordResetTicket.getProperties().get("token").toString();
            String username = this.passwordManagementService.parseToken(token);
            PasswordManagementQuery query = PasswordManagementQuery.builder().username(username).build();
            PasswordManagementWebflowUtils.putPasswordResetToken(requestContext, token);
            PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
            if (pm.getReset().isSecurityQuestionsEnabled()) {
                List questions = PasswordManagementService.canonicalizeSecurityQuestions((Map)this.passwordManagementService.getSecurityQuestions(query));
                if (questions.isEmpty()) {
                    LOGGER.warn("No security questions could be found for [{}]", (Object)username);
                    Event event2 = this.error();
                    return event2;
                }
                PasswordManagementWebflowUtils.putPasswordResetSecurityQuestions(requestContext, questions);
            } else {
                LOGGER.debug("Security questions are not enabled");
            }
            PasswordManagementWebflowUtils.putPasswordResetUsername(requestContext, username);
            PasswordManagementWebflowUtils.putPasswordResetSecurityQuestionsEnabled(requestContext, pm.getReset().isSecurityQuestionsEnabled());
            if (pm.getReset().isSecurityQuestionsEnabled()) {
                LOGGER.trace("Security questions are enabled; proceeding...");
                event = this.success();
                return event;
            }
            event = new EventFactorySupport().event((Object)this, EVENT_ID_SECURITY_QUESTIONS_DISABLED);
            return event;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (String)"Password reset token could not be located or verified", (Throwable)e);
            Event event = this.error();
            return event;
        }
        finally {
            if (passwordResetTicket != null && passwordResetTicket.getExpirationPolicy().isExpired((TicketGrantingTicketAwareTicket)passwordResetTicket)) {
                this.ticketRegistry.deleteTicket((Ticket)passwordResetTicket);
            }
        }
    }

    @Generated
    public VerifyPasswordResetRequestAction(CasConfigurationProperties casProperties, PasswordManagementService passwordManagementService, TicketRegistry ticketRegistry) {
        this.casProperties = casProperties;
        this.passwordManagementService = passwordManagementService;
        this.ticketRegistry = ticketRegistry;
    }
}

