/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security.jws;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AccessTokenJWSVerifier
implements JWSVerifier {
    private final JWSVerifier delegate;

    public AccessTokenJWSVerifier(JWSAlgorithm jwsAlgorithm, String jwsKey) throws JOSEException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm)) {
            if (jwsKey.indexOf(58) == -1) {
                throw new IllegalArgumentException("A key pair is required, in the 'private:public' format");
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(StringUtils.substringAfter((String)jwsKey, (String)":").getBytes()));
            this.delegate = new RSASSAVerifier((RSAPublicKey)kf.generatePublic(keySpecX509));
        } else if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            this.delegate = new MACVerifier(jwsKey);
        } else {
            throw new IllegalArgumentException("Unsupported JWS algorithm: " + jwsAlgorithm.getName());
        }
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return this.delegate.supportedJWSAlgorithms();
    }

    public JCAContext getJCAContext() {
        return this.delegate.getJCAContext();
    }

    public boolean verify(JWSHeader header, byte[] signingInput, Base64URL signature) throws JOSEException {
        return this.delegate.verify(header, signingInput, signature);
    }
}

