/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.SAML2IdPEntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPEntityDAO;
import org.apache.syncope.core.persistence.api.entity.am.SAML2IdPEntity;
import org.apache.syncope.core.provisioning.api.data.SAML2IdPEntityDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class SAML2IdPEntityLogic
extends AbstractTransactionalLogic<SAML2IdPEntityTO> {
    protected final SAML2IdPEntityDataBinder binder;
    protected final SAML2IdPEntityDAO entityDAO;

    public SAML2IdPEntityLogic(SAML2IdPEntityDataBinder binder, SAML2IdPEntityDAO entityDAO) {
        this.binder = binder;
        this.entityDAO = entityDAO;
    }

    @PreAuthorize(value="hasRole('SAML2_IDP_ENTITY_LIST')")
    @Transactional(readOnly=true)
    public List<SAML2IdPEntityTO> list() {
        return this.entityDAO.findAll().stream().map(arg_0 -> ((SAML2IdPEntityDataBinder)this.binder).getSAML2IdPEntityTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('SAML2_IDP_ENTITY_GET') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public SAML2IdPEntityTO get(String key) {
        return Optional.ofNullable(this.entityDAO.find(key)).map(arg_0 -> ((SAML2IdPEntityDataBinder)this.binder).getSAML2IdPEntityTO(arg_0)).orElseThrow(() -> new NotFoundException(key + " not found"));
    }

    @PreAuthorize(value="hasRole('SAML2_IDP_ENTITY_SET') or hasRole('ANONYMOUS')")
    public SAML2IdPEntityTO set(SAML2IdPEntityTO entityTO) {
        SAML2IdPEntity entity = Optional.ofNullable(this.entityDAO.find(entityTO.getKey())).map(metadata -> this.binder.update(metadata, entityTO)).orElseGet(() -> this.binder.create(entityTO));
        return this.binder.getSAML2IdPEntityTO(this.entityDAO.save(entity));
    }

    protected SAML2IdPEntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof SAML2IdPEntityTO)) continue;
                key = ((SAML2IdPEntityTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getSAML2IdPEntityTO(this.entityDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

