/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.util.regex.Pattern;
import org.hjson.IHjsonDsfProvider;
import org.hjson.JsonNumber;
import org.hjson.JsonValue;

class DsfHex
implements IHjsonDsfProvider {
    boolean stringify;
    static Pattern isHex = Pattern.compile("^0x[0-9A-Fa-f]+$");

    public DsfHex(boolean stringify) {
        this.stringify = stringify;
    }

    @Override
    public String getName() {
        return "hex";
    }

    @Override
    public String getDescription() {
        return "parse hexadecimal numbers prefixed with 0x";
    }

    @Override
    public JsonValue parse(String text) {
        if (isHex.matcher(text).find()) {
            return new JsonNumber(Long.parseLong(text.substring(2), 16));
        }
        return null;
    }

    @Override
    public String stringify(JsonValue value) {
        if (this.stringify && value.isNumber() && (double)value.asLong() == value.asDouble()) {
            return "0x" + Long.toHexString(value.asLong());
        }
        return null;
    }
}

