/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.ClassUtils;
import org.springmodules.cache.util.TextMatcher;

final class MethodMatcher {
    MethodMatcher() {
    }

    Collection matchingMethods(String fullyQualifiedMethodName) throws IllegalArgumentException {
        MethodFQN parser = new MethodFQN(fullyQualifiedMethodName);
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        Method[] methods = this.methods(parser.className);
        for (int i = 0; i < methods.length; ++i) {
            if (!this.matchingMethod(methods[i], parser.methodName)) continue;
            matchingMethods.add(methods[i]);
        }
        return matchingMethods;
    }

    private Class load(String className) throws IllegalArgumentException {
        Class declaringClass = null;
        try {
            declaringClass = ClassUtils.forName((String)className);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Class '" + className + "' not found");
        }
        return declaringClass;
    }

    private boolean matchingMethod(Method method, String target) {
        String n = method.getName();
        return n.equals(target) || TextMatcher.isMatch(n, target);
    }

    private Method[] methods(String className) throws IllegalArgumentException {
        Class declaringClass = this.load(className);
        return declaringClass.getDeclaredMethods();
    }

    private class MethodFQN {
        final String className;
        final String methodName;

        MethodFQN(String fqn) throws IllegalArgumentException {
            int separatorIndex = this.methodSeparator(fqn);
            this.className = fqn.substring(0, separatorIndex);
            this.methodName = fqn.substring(separatorIndex + 1);
        }

        private int methodSeparator(String fqn) {
            int separatorIndex = fqn.lastIndexOf(".");
            if (separatorIndex == -1) {
                throw new IllegalArgumentException("'" + fqn + "' is not a fully qualified name");
            }
            return separatorIndex;
        }
    }
}

