/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.fasterxml.jackson.databind.json.JsonMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.syncope.client.console.PreferenceManager;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryPanel<T extends Serializable, W extends Serializable, DP extends DirectoryDataProvider<T>, E extends RestClient>
extends WizardMgtPanel<W> {
    private static final long serialVersionUID = -9170191461250434024L;
    protected static final Logger LOG = LoggerFactory.getLogger(DirectoryPanel.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected E restClient;
    protected Integer rows;
    protected final WebMarkupContainer container;
    protected final boolean filtered;
    private boolean checkBoxEnabled;
    private boolean showPaginator;
    protected AjaxDataTablePanel<T, String> resultTable;
    protected DP dataProvider;
    protected final BasePage page;
    protected String itemKeyFieldName = "key";
    protected final BaseModal<W> altDefaultModal = new BaseModal("outer");
    protected final BaseModal<W> displayAttributeModal = new BaseModal("outer");
    protected final ActionLinksTogglePanel<T> actionTogglePanel;

    public DirectoryPanel(String id, E restClient, PageReference pageRef) {
        this(id, restClient, pageRef, true);
    }

    public DirectoryPanel(String id, E restClient, PageReference pageRef, boolean wizardInModal) {
        this(id, restClient, pageRef, true, wizardInModal);
    }

    public DirectoryPanel(String id, E restClient, PageReference pageRef, boolean showPaginator, boolean wizardInModal) {
        this(id, new Builder<T, W, E>((RestClient)restClient, pageRef){
            private static final long serialVersionUID = -8424727765826509309L;

            @Override
            protected WizardMgtPanel<W> newInstance(String id, boolean wizardInModal) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }.setFiltered(false), wizardInModal);
        this.setPageRef(pageRef);
        this.showPaginator = showPaginator;
    }

    protected DirectoryPanel(String id, Builder<T, W, E> builder) {
        this(id, builder, true);
    }

    protected DirectoryPanel(String id, Builder<T, W, E> builder, boolean wizardInModal) {
        super(id, wizardInModal);
        this.setOutputMarkupId(true);
        this.actionTogglePanel = this.actionTogglePanel();
        this.addOuterObject(new Component[]{this.actionTogglePanel});
        this.addOuterObject(new Component[]{this.altDefaultModal});
        this.addOuterObject(new Component[]{this.displayAttributeModal});
        this.setPageRef(builder.getPageRef());
        this.page = (BasePage)builder.getPageRef().getPage();
        this.filtered = builder.filtered;
        this.checkBoxEnabled = builder.checkBoxEnabled;
        this.showPaginator = builder.showPaginator;
        this.restClient = builder.restClient;
        this.container = new WebMarkupContainer("searchContainer");
        this.container.setOutputMarkupId(true);
        this.addInnerObject(new Component[]{this.container});
        this.rows = PreferenceManager.getPaginatorRows(this.paginatorRowsKey());
        this.setWindowClosedReloadCallback(this.modal);
        this.altDefaultModal.size(Modal.Size.Default);
        this.setWindowClosedReloadCallback(this.altDefaultModal);
        this.displayAttributeModal.size(Modal.Size.Default);
        this.displayAttributeModal.addSubmitButton();
        this.displayAttributeModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            EventDataWrapper data = new EventDataWrapper();
            data.setTarget(target);
            data.setRows(this.rows);
            this.send((IEventSink)this, Broadcast.EXACT, data);
            this.modal.show(false);
        });
    }

    @Override
    protected void setWindowClosedReloadCallback(BaseModal<?> baseModal) {
        this.setWindowClosedReloadCallback(baseModal, false);
    }

    protected void setWindowClosedReloadCallback(BaseModal<?> baseModal, boolean updateResultTable) {
        baseModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            if (this.actionTogglePanel.isVisibleInHierarchy()) {
                this.actionTogglePanel.toggle(target, false);
            }
            if (updateResultTable) {
                this.updateResultTable(target);
            }
            baseModal.show(false);
        });
    }

    protected abstract DP dataProvider();

    protected abstract String paginatorRowsKey();

    protected abstract List<IColumn<T, String>> getColumns();

    protected void initResultTable() {
        this.updateResultTable(false);
        Form paginatorForm = new Form("paginator");
        paginatorForm.setOutputMarkupPlaceholderTag(true);
        paginatorForm.setVisible(this.showPaginator);
        this.container.add(new Component[]{paginatorForm});
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "rows"), PreferenceManager.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PreferenceManager.set(DirectoryPanel.this.paginatorRowsKey(), String.valueOf(DirectoryPanel.this.rows));
                EventDataWrapper data = new EventDataWrapper();
                data.setTarget(target);
                data.setRows(DirectoryPanel.this.rows);
                DirectoryPanel.this.send((IEventSink)DirectoryPanel.this.getParent(), Broadcast.BREADTH, data);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.container.add(new Component[]{this.getHeader("tablehandling")});
    }

    protected ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = new ActionsPanel<Serializable>(componentId, null);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                if (target != null) {
                    target.add(new Component[]{DirectoryPanel.this.container});
                }
            }
        }, ActionLink.ActionType.RELOAD, "USER_SEARCH").hideLabel();
        return panel;
    }

    public void search(AjaxRequestTarget target) {
        target.add(new Component[]{this.container});
    }

    public void updateResultTable(AjaxRequestTarget target) {
        this.updateResultTable(false);
        if (this.container.isVisibleInHierarchy()) {
            target.add(new Component[]{this.container});
        }
    }

    protected void updateResultTable(boolean create) {
        this.updateResultTable(create, this.rows);
    }

    protected void updateResultTable(boolean create, int rows) {
        if (this.dataProvider == null) {
            this.dataProvider = this.dataProvider();
        }
        ((DirectoryDataProvider)((Object)this.dataProvider)).setPaginatorRows(rows);
        int currentPage = Optional.ofNullable(this.resultTable).map(table -> create ? (int)table.getPageCount() - 1 : (int)table.getCurrentPage()).orElse(0);
        AjaxDataTablePanel.Builder resultTableBuilder = new AjaxDataTablePanel.Builder<T, String>((ISortableDataProvider)this.dataProvider, this.page.getPageReference()){
            private static final long serialVersionUID = 2205322679547329123L;

            @Override
            protected ActionsPanel<T> getActions(IModel<T> model) {
                return DirectoryPanel.this.getActions(model);
            }

            @Override
            protected ActionLinksTogglePanel<T> getTogglePanel() {
                return DirectoryPanel.this.getTogglePanel();
            }

            @Override
            protected BiConsumer<AjaxRequestTarget, IModel<T>> onDoubleClick() {
                return DirectoryPanel.this.onDoubleClick();
            }
        }.setColumns(this.getColumns()).setRowsPerPage(rows).setBatches(this.getBatches(), (RestClient)this.restClient, this.itemKeyFieldName).setContainer(this.container);
        if (!this.checkBoxEnabled) {
            resultTableBuilder.disableCheckBoxes();
        }
        this.resultTableCustomChanges(resultTableBuilder);
        this.resultTable = resultTableBuilder.build("resultTable");
        this.resultTable.setCurrentPage(currentPage);
        this.resultTable.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{this.resultTable});
    }

    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<T, String> resultTableBuilder) {
    }

    public DirectoryPanel<T, W, DP, E> disableCheckBoxes() {
        this.checkBoxEnabled = false;
        return this;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof EventDataWrapper) {
            EventDataWrapper data = (EventDataWrapper)event.getPayload();
            if (data.getRows() < 1) {
                this.updateResultTable(data.isCreate());
            } else {
                this.updateResultTable(data.isCreate(), data.getRows());
            }
            if (this.container.isVisibleInHierarchy()) {
                data.getTarget().add(new Component[]{this.container});
            }
        }
        super.onEvent(event);
    }

    @Override
    protected void customActionOnFinishCallback(AjaxRequestTarget target) {
        EventDataWrapper data = new EventDataWrapper();
        data.setTarget(target);
        data.setRows(this.rows);
        this.send((IEventSink)this.getParent(), Broadcast.BREADTH, data);
    }

    protected ActionsPanel<T> getActions(IModel<T> model) {
        return new ActionsPanel("actions", model == null ? new Model() : model);
    }

    protected ActionLinksTogglePanel<T> actionTogglePanel() {
        return new ActionLinksTogglePanel("outer", this.pageRef);
    }

    protected ActionLinksTogglePanel<T> getTogglePanel() {
        return this.actionTogglePanel;
    }

    protected BiConsumer<AjaxRequestTarget, IModel<T>> onDoubleClick() {
        return null;
    }

    protected abstract Collection<ActionLink.ActionType> getBatches();

    public static abstract class Builder<T extends Serializable, W extends Serializable, E extends RestClient>
    extends WizardMgtPanel.Builder<W> {
        private static final long serialVersionUID = 5088962796986706805L;
        protected boolean filtered = false;
        protected boolean checkBoxEnabled = true;
        protected boolean showPaginator = true;
        protected String fiql;
        protected final E restClient;

        protected Builder(E restClient, PageReference pageRef) {
            super(pageRef);
            this.restClient = restClient;
        }

        public Builder<T, W, E> setFiltered(boolean filtered) {
            this.filtered = filtered;
            return this;
        }

        public Builder<T, W, E> disableCheckBoxes() {
            this.checkBoxEnabled = false;
            return this;
        }

        public Builder<T, W, E> hidePaginator() {
            this.showPaginator = false;
            return this;
        }

        public Builder<T, W, E> setFiql(String fiql) {
            this.fiql = fiql;
            return this;
        }

        private PageReference getPageRef() {
            return this.pageRef;
        }
    }

    public static class EventDataWrapper {
        private AjaxRequestTarget target;
        private boolean create;
        private int rows;

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public void setTarget(AjaxRequestTarget target) {
            this.target = target;
        }

        public boolean isCreate() {
            return this.create;
        }

        public void setCreate(boolean create) {
            this.create = create;
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }
    }
}

