/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.AnyTypeService;
import org.apache.syncope.common.rest.api.service.SchemaService;

public class SchemaRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -2479730152700312373L;

    public <T extends SchemaTO> List<T> getSchemas(SchemaType schemaType, AnyTypeKind kind) {
        AnyTypeService client = this.getService(AnyTypeService.class);
        ArrayList classes = new ArrayList();
        switch (kind) {
            case USER: 
            case GROUP: {
                AnyTypeTO type = client.read(kind.name());
                if (type == null) break;
                classes.addAll(type.getClasses());
                break;
            }
            default: {
                this.getService(AnyTypeService.class).list().stream().filter(anyType -> anyType.getKind() != AnyTypeKind.USER && anyType.getKind() != AnyTypeKind.GROUP).forEach(anyType -> classes.addAll(anyType.getClasses()));
            }
        }
        return this.getSchemas(schemaType, null, (String[])classes.toArray(String[]::new));
    }

    public <T extends SchemaTO> List<T> getSchemas(SchemaType schemaType, String keyword, String ... anyTypeClasses) {
        SchemaQuery.Builder builder = new SchemaQuery.Builder().type(schemaType);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            builder.keyword(keyword);
        }
        if (anyTypeClasses != null && anyTypeClasses.length > 0) {
            builder.anyTypeClasses(anyTypeClasses);
        }
        ArrayList schemas = new ArrayList();
        try {
            schemas.addAll(this.getService(SchemaService.class).search(builder.build()));
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all {} schemas for {}", new Object[]{schemaType, anyTypeClasses, e});
        }
        return schemas;
    }

    public List<String> getSchemaNames(SchemaType schemaType) {
        List<String> schemaNames = List.of();
        try {
            schemaNames = this.getSchemas(schemaType, null, new String[0]).stream().map(SchemaTO::getKey).collect(Collectors.toList());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all user schema names", (Throwable)e);
        }
        return schemaNames;
    }

    public <T extends SchemaTO> T read(SchemaType schemaType, String key) {
        return (T)this.getService(SchemaService.class).read(schemaType, key);
    }

    public void create(SchemaType schemaType, SchemaTO modelObject) {
        this.getService(SchemaService.class).create(schemaType, modelObject);
    }

    public void update(SchemaType schemaType, SchemaTO modelObject) {
        this.getService(SchemaService.class).update(schemaType, modelObject);
    }

    public void delete(SchemaType schemaType, String key) {
        this.getService(SchemaService.class).delete(schemaType, key);
    }
}

