/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.audit.spi.resource.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.util.AopUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.aspectj.lang.JoinPoint;

public class TicketValidationResourceResolver
extends TicketAsFirstParameterResourceResolver {
    private AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.DEFAULT;

    public TicketValidationResourceResolver(AuthenticationServiceSelectionPlan serviceSelectionStrategy) {
        super(serviceSelectionStrategy);
    }

    @Override
    public String[] resolveFrom(JoinPoint joinPoint, Object object) {
        String[] stringArray;
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        Object[] args = AopUtils.unWrapJoinPoint((JoinPoint)joinPoint).getArgs();
        if (args != null && args.length > 0) {
            String ticketId = args[0].toString();
            results.put("ticket", ticketId);
        }
        if (object instanceof Assertion) {
            Assertion assertion = (Assertion)Assertion.class.cast(object);
            Authentication authn = assertion.getPrimaryAuthentication();
            results.put("principal", authn.getPrincipal().getId());
            HashMap attributes = new HashMap(authn.getAttributes());
            attributes.putAll(authn.getPrincipal().getAttributes());
            results.put("attributes", attributes);
        }
        if (results.isEmpty()) {
            stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.auditFormat.serialize(results);
        }
        return stringArray;
    }

    @Override
    @Generated
    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditFormat = auditFormat;
    }
}

