/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.lang.Nullable;

@Endpoint(id="auditLog", enableByDefault=false)
public class AuditLogEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<AuditTrailExecutionPlan> auditTrailManager;

    public AuditLogEndpoint(ObjectProvider<AuditTrailExecutionPlan> auditTrailManager, CasConfigurationProperties casProperties) {
        super(casProperties);
        this.auditTrailManager = auditTrailManager;
    }

    @ReadOperation
    @Operation(summary="Provide a report of the audit log using a given interval", parameters={@Parameter(name="interval", description="Accepts the duration syntax, such as PT1H")})
    public Set<AuditActionContext> getAuditLog(@Selector String interval) {
        if (StringUtils.isBlank((CharSequence)interval)) {
            LocalDate sinceDate = LocalDate.now(ZoneId.systemDefault()).minusDays(this.casProperties.getAudit().getEngine().getNumberOfDaysInHistory());
            return ((AuditTrailExecutionPlan)this.auditTrailManager.getObject()).getAuditRecords(Map.of(AuditTrailManager.WhereClauseFields.DATE, sinceDate));
        }
        Duration duration = Beans.newDuration((String)interval);
        Date sinceTime = new Date(new Date().getTime() - duration.toMillis());
        long days = duration.toDays();
        LocalDate sinceDate = LocalDate.now(ZoneId.systemDefault()).minusDays(days + 1L);
        return ((AuditTrailExecutionPlan)this.auditTrailManager.getObject()).getAuditRecords(Map.of(AuditTrailManager.WhereClauseFields.DATE, sinceDate)).stream().filter(a -> a.getWhenActionWasPerformed().after(sinceTime)).collect(Collectors.toSet());
    }

    @WriteOperation(produces={"application/vnd.cas.services+yaml", "application/json"})
    @Operation(summary="Provide a report of the audit log. Each filter other than `interval` can accept a regular expression to match against.", parameters={@Parameter(name="interval", description="Accepts the duration syntax, such as PT1H"), @Parameter(name="actionPerformed"), @Parameter(name="clientIpAddress"), @Parameter(name="principal"), @Parameter(name="resourceOperatedUpon")})
    public Set<AuditActionContext> getAuditLog(@Nullable String interval, @Nullable String actionPerformed, @Nullable String clientIpAddress, @Nullable String principal, @Nullable String resourceOperatedUpon) {
        return this.getAuditLog(interval).stream().filter(e -> StringUtils.isBlank((CharSequence)actionPerformed) || e.getActionPerformed().matches(actionPerformed)).filter(e -> StringUtils.isBlank((CharSequence)clientIpAddress) || e.getClientIpAddress().matches(clientIpAddress)).filter(e -> StringUtils.isBlank((CharSequence)principal) || e.getPrincipal().matches(principal)).filter(e -> StringUtils.isBlank((CharSequence)resourceOperatedUpon) || e.getResourceOperatedUpon().matches(resourceOperatedUpon)).collect(Collectors.toSet());
    }
}

