/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleListViewPanel<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleListViewPanel.class);
    private final ListView<T> beans;
    private final List<T> listOfItems;

    private SimpleListViewPanel(String id, List<T> list, Class<T> reference, List<String> includes) {
        super(id);
        List<Object> toBeIncluded;
        this.setOutputMarkupId(true);
        if (includes == null || includes.isEmpty()) {
            toBeIncluded = new ArrayList();
            for (Field field : reference.getDeclaredFields()) {
                toBeIncluded.add(field.getName());
            }
        } else {
            toBeIncluded = includes;
        }
        if (toBeIncluded.isEmpty()) {
            LOG.warn("No field has been retrieved from {}", (Object)reference.getName());
            this.listOfItems = new ArrayList<T>();
        } else if (list == null || list.isEmpty()) {
            LOG.info("No item to be shown");
            this.listOfItems = new ArrayList<T>();
        } else {
            this.listOfItems = list;
            LOG.debug("Show fields {}", toBeIncluded);
        }
        this.add(new Component[]{this.header(toBeIncluded)});
        this.beans = new ListView<T>("beans", this.listOfItems){
            private static final long serialVersionUID = -9112553137618363167L;

            protected void populateItem(ListItem<T> beanItem) {
                final Serializable bean = (Serializable)beanItem.getModelObject();
                ListView<String> fields = new ListView<String>("fields", toBeIncluded){
                    private static final long serialVersionUID = -9112553137618363167L;

                    protected void populateItem(ListItem<String> fieldItem) {
                        fieldItem.add(new Component[]{SimpleListViewPanel.this.getValueComponent((String)fieldItem.getModelObject(), bean)});
                    }
                };
                beanItem.add(new Component[]{fields});
            }
        };
        this.add(new Component[]{this.beans.setOutputMarkupId(true).setRenderBodyOnly(true)});
    }

    protected ListView<String> header(List<String> labels) {
        return new ListView<String>("names", labels){
            private static final long serialVersionUID = -9112553137618363167L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Label("name", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
            }
        };
    }

    protected abstract T getActualItem(T var1, List<T> var2);

    protected abstract Component getValueComponent(String var1, T var2);

    public static class Builder<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -3643771352897992172L;
        private final List<String> includes = new ArrayList<String>();
        private List<T> items;
        private final Class<T> reference;
        private final PageReference pageReference;

        public Builder(Class<T> reference, PageReference pageRef) {
            this.pageReference = pageRef;
            this.reference = reference;
            this.items = null;
        }

        public Builder<T> setItems(List<T> items) {
            this.items = items;
            return this;
        }

        public Builder<T> addItem(T item) {
            if (item == null) {
                return this;
            }
            if (this.items == null) {
                this.items = new ArrayList<T>();
            }
            this.items.add(item);
            return this;
        }

        public Builder<T> includes(String ... includes) {
            for (String include : includes) {
                if (include == null || this.includes.contains(include)) continue;
                this.includes.add(include);
            }
            return this;
        }

        protected Component getValueComponent(String key, T bean) {
            String value;
            LOG.debug("Processing field {}", (Object)key);
            try {
                value = this.includes.contains(key) ? PropertyResolver.getPropertyGetter((String)key, bean).invoke(bean, new Object[0]) : "";
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("Error retrieving value for field {}", (Object)key, (Object)e);
                value = "";
            }
            LOG.debug("Field value {}", (Object)value);
            return (Component)Optional.ofNullable(value).map(o -> new Label("field", (IModel)new ResourceModel(o.toString(), o.toString()))).orElseGet(() -> new Label("field", (Serializable)((Object)"")));
        }

        protected T getActualItem(T item, List<T> list) {
            return (T)(item == null ? null : (Serializable)list.stream().filter(item::equals).findAny().orElse(null));
        }

        public SimpleListViewPanel<T> build(String id) {
            return new SimpleListViewPanel<T>(id, this.items, this.reference, this.includes){

                @Override
                protected Component getValueComponent(String key, T bean) {
                    return this.getValueComponent(key, bean);
                }

                @Override
                protected T getActualItem(T item, List<T> list) {
                    return this.getActualItem(item, list);
                }
            };
        }
    }
}

