/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.application;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.application.ProvisioningConnection;
import com.okta.sdk.resource.application.ProvisioningConnectionAuthScheme;
import com.okta.sdk.resource.application.ProvisioningConnectionProfile;
import com.okta.sdk.resource.application.ProvisioningConnectionRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultProvisioningConnectionProfile
extends AbstractResource
implements ProvisioningConnectionProfile {
    private static final EnumProperty<ProvisioningConnectionAuthScheme> authSchemeProperty = new EnumProperty<ProvisioningConnectionAuthScheme>("authScheme", ProvisioningConnectionAuthScheme.class);
    private static final StringProperty tokenProperty = new StringProperty("token");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultProvisioningConnectionProfile.createPropertyDescriptorMap(authSchemeProperty, tokenProperty);

    public DefaultProvisioningConnectionProfile(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultProvisioningConnectionProfile(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public ProvisioningConnectionAuthScheme getAuthScheme() {
        return this.getEnumProperty(authSchemeProperty);
    }

    public ProvisioningConnectionProfile setAuthScheme(ProvisioningConnectionAuthScheme authScheme) {
        this.setProperty(authSchemeProperty, (Object)authScheme);
        return this;
    }

    public String getToken() {
        return this.getString(tokenProperty);
    }

    public ProvisioningConnectionProfile setToken(String token) {
        this.setProperty(tokenProperty, (Object)token);
        return this;
    }

    public ProvisioningConnection setDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest profile, Boolean activate) {
        Assert.notNull((Object)profile, (String)"'profile' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default", profile, this, ProvisioningConnection.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public ProvisioningConnection setDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest profile) {
        Assert.notNull((Object)profile, (String)"'profile' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default", profile, this, ProvisioningConnection.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }
}

