/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.AbstractAsyncHistoryManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class AsyncHistoryManager
extends AbstractAsyncHistoryManager {
    public AsyncHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public AsyncHistorySession getAsyncHistorySession() {
        return this.getSession(AsyncHistorySession.class);
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForProcessInstance(processInstance)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonProcessInstanceFields(processInstance, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-start", data, processInstance.getTenantId());
        }
    }

    @Override
    public void recordProcessInstanceEnd(ExecutionEntity processInstance, String deleteReason, String activityId, Date endTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForProcessInstance(processInstance)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonProcessInstanceFields(processInstance, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)endTime);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityId", (String)activityId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-end", data);
        }
    }

    @Override
    public void recordProcessInstanceNameChange(ExecutionEntity processInstanceExecution, String newName) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForProcessInstance(processInstanceExecution)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)processInstanceExecution.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)newName);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)processInstanceExecution.getRevision());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"property", (String)"name");
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-property-changed", data);
        }
    }

    @Override
    public void recordProcessInstanceDeleted(String processInstanceId, String processDefinitionId, String processTenantId) {
        if (this.isHistoryEnabled(processDefinitionId)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)processInstanceId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-deleted", data);
        }
    }

    @Override
    public void recordDeleteHistoricProcessInstancesByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEnabled(processDefinitionId)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)processDefinitionId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-deleted-by-process-definition-id", data);
        }
    }

    @Override
    public void recordBulkDeleteProcessInstances(Collection<String> processInstanceIds) {
        if (this.isHistoryEnabled() && processInstanceIds != null && !processInstanceIds.isEmpty()) {
            this.getHistoricDetailEntityManager().bulkDeleteHistoricDetailsByProcessInstanceIds(processInstanceIds);
            this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().bulkDeleteHistoricVariableInstancesByProcessInstanceIds(processInstanceIds);
            this.getHistoricActivityInstanceEntityManager().bulkDeleteHistoricActivityInstancesByProcessInstanceIds(processInstanceIds);
            TaskHelper.bulkDeleteHistoricTaskInstancesForProcessInstanceIds(processInstanceIds);
            this.processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().bulkDeleteHistoricIdentityLinksForProcessInstanceIds(processInstanceIds);
            if (this.processEngineConfiguration.isEnableEntityLinks()) {
                this.processEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService().bulkDeleteHistoricEntityLinksForScopeTypeAndScopeIds("bpmn", processInstanceIds);
            }
            this.getCommentEntityManager().bulkDeleteCommentsForProcessInstanceIds(processInstanceIds);
            this.getHistoricProcessInstanceEntityManager().bulkDeleteHistoricProcessInstances(processInstanceIds);
            List<String> subProcessInstanceIds = this.getHistoricProcessInstanceEntityManager().findHistoricProcessInstanceIdsBySuperProcessInstanceIds(processInstanceIds);
            if (subProcessInstanceIds != null && !subProcessInstanceIds.isEmpty()) {
                this.processEngineConfiguration.getHistoryManager().recordBulkDeleteProcessInstances(subProcessInstanceIds);
            }
        }
    }

    @Override
    public void recordActivityStart(ActivityInstance activityInstance) {
        if (activityInstance != null && this.getHistoryConfigurationSettings().isHistoryEnabledForActivity(activityInstance) && activityInstance.getActivityId() != null) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonActivityInstanceFields(activityInstance, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startTime", (Date)activityInstance.getStartTime());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-start", data, activityInstance.getTenantId());
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason, Date endTime) {
        String activityId;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForActivity(executionEntity.getProcessDefinitionId(), executionEntity.getActivityId()) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getActivityIdForExecution(executionEntity)))) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)executionEntity.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)executionEntity.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)executionEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityId", (String)activityId);
            if (executionEntity.getCurrentFlowElement() != null) {
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityName", (String)executionEntity.getCurrentFlowElement().getName());
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityType", (String)this.parseActivityType(executionEntity.getCurrentFlowElement()));
            }
            if (executionEntity.getTenantId() != null) {
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)executionEntity.getTenantId());
            }
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)endTime);
            ObjectNode correspondingActivityStartData = this.getActivityStart(executionEntity.getId(), activityId, true);
            if (correspondingActivityStartData == null) {
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-end", data);
            } else {
                data.put("startTime", AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)correspondingActivityStartData, (String)"startTime"));
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-full", data);
            }
        }
    }

    @Override
    public void recordActivityEnd(ActivityInstance activityInstance) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForActivity(activityInstance) && StringUtils.isNotEmpty((CharSequence)activityInstance.getActivityId())) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonActivityInstanceFields(activityInstance, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"deleteReason", (String)activityInstance.getDeleteReason());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)activityInstance.getEndTime());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startTime", (Date)activityInstance.getStartTime());
            ObjectNode correspondingActivityStartData = this.getActivityStart(activityInstance.getId(), true);
            if (correspondingActivityStartData == null) {
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-end", data);
            } else {
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-full", data);
            }
        }
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)processInstanceId);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)processDefinitionId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "set-process-definition", data);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask(execution, task)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonTaskFields(task, execution, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-created", data, task.getTenantId());
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, ExecutionEntity execution, String deleteReason, Date endTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask(execution, task)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonTaskFields(task, execution, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)endTime);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-ended", data);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity, String runtimeActivityInstanceId, Date changeTime) {
        Map originalPersistentState;
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)taskEntity)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonTaskFields(taskEntity, null, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-property-changed", data);
        }
        if ((originalPersistentState = (Map)taskEntity.getOriginalPersistentState()) == null && taskEntity.getAssignee() != null || originalPersistentState != null && !Objects.equals(originalPersistentState.get("assignee"), taskEntity.getAssignee())) {
            this.handleTaskAssigneeChange(taskEntity, runtimeActivityInstanceId, changeTime);
        }
        if (originalPersistentState == null && taskEntity.getOwner() != null || originalPersistentState != null && !Objects.equals(originalPersistentState.get("owner"), taskEntity.getOwner())) {
            this.handleTaskOwnerChange(taskEntity, runtimeActivityInstanceId, changeTime);
        }
    }

    protected void handleTaskAssigneeChange(TaskEntity taskEntity, String activityInstanceId, Date changeTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForActivity(taskEntity.getProcessDefinitionId(), taskEntity.getTaskDefinitionKey())) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"assignee", (String)taskEntity.getAssignee());
            if (taskEntity.getExecutionId() != null) {
                ExecutionEntity executionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId());
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)executionEntity.getId());
                String activityId = this.getActivityIdForExecution(executionEntity);
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityId", (String)activityId);
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"runtimeActivityInstanceId", (String)activityInstanceId);
                if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, taskEntity.getProcessDefinitionId())) {
                    ObjectNode activityStartData = this.getActivityStart(executionEntity.getId(), activityId, false);
                    if (activityStartData != null) {
                        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)activityStartData, (String)"assignee", (String)taskEntity.getAssignee());
                        data.put("activityAssigneeHandled", String.valueOf(true));
                    }
                } else {
                    data.put("activityAssigneeHandled", String.valueOf(true));
                }
            }
            if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)taskEntity)) {
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)taskEntity.getId());
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)changeTime);
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-assignee-changed", data);
            }
        }
    }

    protected void handleTaskOwnerChange(TaskEntity taskEntity, String activityInstanceId, Date changeTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)taskEntity)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)taskEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"owner", (String)taskEntity.getOwner());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)changeTime);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"runtimeActivityInstanceId", (String)activityInstanceId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-owner-changed", data);
        }
    }

    @Override
    public void recordHistoricTaskDeleted(HistoricTaskInstance task) {
        if (task != null && this.getHistoryConfigurationSettings().isHistoryEnabledForUserTask((TaskInfo)task)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)task.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-deleted", data);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable, Date createTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForVariableInstance(variable)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonVariableFields(variable, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)createTime);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "variable-created", data);
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId, String activityInstanceId, Date createTime) {
        String processDefinitionId = this.getProcessDefinitionId(variable, sourceActivityExecution);
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForVariableInstance(processDefinitionId, variable) && this.isHistoryLevelAtLeast(HistoryLevel.FULL, processDefinitionId)) {
            String activityId;
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonVariableFields(variable, data);
            if (sourceActivityExecution != null && sourceActivityExecution.isMultiInstanceRoot()) {
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"isMiRootExecution", (Boolean)true);
            }
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)createTime);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"runtimeActivityInstanceId", (String)activityInstanceId);
            if (useActivityId && sourceActivityExecution != null && (activityId = this.getActivityIdForExecution(sourceActivityExecution)) != null) {
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityId", (String)activityId);
                AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"sourceExecutionId", (String)sourceActivityExecution.getId());
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "historic-detail-variable-update", data);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable, Date updateTime) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForVariableInstance(variable)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonVariableFields(variable, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastUpdatedTime", (Date)updateTime);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "variable-updated", data);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForVariableInstance(variable)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)variable.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)variable.getRevision());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "variable-removed", data);
        }
    }

    @Override
    public void recordFormPropertiesSubmitted(ExecutionEntity execution, Map<String, String> properties, String taskId, Date createTime) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, execution.getProcessDefinitionId())) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addProcessDefinitionFields(data, execution.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)execution.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)execution.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)taskId);
            String activityId = this.getActivityIdForExecution(execution);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityId", (String)activityId);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)createTime);
            int counter = 1;
            for (String propertyId : properties.keySet()) {
                String propertyValue = properties.get(propertyId);
                data.put("formPropertyId" + counter, propertyId);
                data.put("formPropertyValue" + counter, propertyValue);
                ++counter;
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "form-properties-submitted", data);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForIdentityLink(identityLink)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonIdentityLinkFields(identityLink, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "identitylink-created", data);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForIdentityLink(identityLink)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)identityLink.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "identitylink-deleted", data);
        }
    }

    @Override
    public void recordEntityLinkCreated(EntityLinkEntity entityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForEntityLink(entityLink)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonEntityLinkFields(entityLink, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "entitylink-created", data);
        }
    }

    @Override
    public void recordEntityLinkDeleted(EntityLinkEntity entityLink) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForEntityLink(entityLink)) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)entityLink.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "entitylink-deleted", data);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstance.getProcessDefinitionId())) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)processInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessKey", (String)processInstance.getBusinessKey());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"property", (String)"businessKey");
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-property-changed", data);
        }
    }

    @Override
    public void updateProcessBusinessStatusInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstance.getProcessDefinitionId())) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)processInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessStatus", (String)processInstance.getBusinessStatus());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"property", (String)"businessStatus");
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-property-changed", data);
        }
    }

    @Override
    public void updateProcessDefinitionIdInHistory(ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance) {
        if (this.isHistoryEnabled(processDefinitionEntity.getId())) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)processDefinitionEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)processInstance.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "update-process-definition-cascade", data);
        }
    }

    @Override
    public void updateHistoricActivityInstance(ActivityInstance activityInstance) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForActivity(activityInstance) && activityInstance.getExecutionId() != null) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"runtimeActivityInstanceId", (String)activityInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)activityInstance.getTaskId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"assignee", (String)activityInstance.getAssignee());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"calledProcessInstanceId", (String)activityInstance.getCalledProcessInstanceId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-update", data);
        }
    }

    @Override
    public void createHistoricActivityInstance(ActivityInstance activityInstance) {
        if (this.getHistoryConfigurationSettings().isHistoryEnabledForActivity(activityInstance) && activityInstance.getExecutionId() != null) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addCommonActivityInstanceFields(activityInstance, data);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startTime", (Date)activityInstance.getStartTime());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)activityInstance.getEndTime());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-full", data);
        }
    }

    @Override
    public void recordHistoricUserTaskLogEntry(HistoricTaskLogEntryBuilder taskLogEntryBuilder) {
        if (this.processEngineConfiguration.isEnableHistoricTaskLogging()) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            this.addHistoricTaskLogEntryFields(taskLogEntryBuilder, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "historic-user-task-log-record", data, taskLogEntryBuilder.getTenantId());
        }
    }

    @Override
    public void deleteHistoryUserTaskLog(long logNumber) {
        if (this.processEngineConfiguration.isEnableHistoricTaskLogging()) {
            ObjectNode data = this.processEngineConfiguration.getObjectMapper().createObjectNode();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"logNumber", (Long)logNumber);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "historic-user-task-log-delete", data);
        }
    }

    protected ObjectNode getActivityStart(String executionId, String activityId, boolean removeFromAsyncHistorySession) {
        Map jobData;
        AsyncHistorySession.AsyncHistorySessionData asyncHistorySessionData;
        Map sessionData = this.getAsyncHistorySession().getSessionData();
        if (sessionData != null && (asyncHistorySessionData = (AsyncHistorySession.AsyncHistorySessionData)sessionData.get(this.getJobServiceConfiguration())) != null && (jobData = asyncHistorySessionData.getJobData()) != null && jobData.containsKey("activity-start")) {
            List activityStartDataList = (List)jobData.get("activity-start");
            Iterator activityStartDataIterator = activityStartDataList.iterator();
            while (activityStartDataIterator.hasNext()) {
                ObjectNode activityStartData = (ObjectNode)activityStartDataIterator.next();
                if (!activityId.equals(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)activityStartData, (String)"activityId")) || !executionId.equals(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)activityStartData, (String)"executionId"))) continue;
                if (removeFromAsyncHistorySession) {
                    activityStartDataIterator.remove();
                }
                return activityStartData;
            }
        }
        return null;
    }

    protected ObjectNode getActivityStart(String runtimeActivityInstanceId, boolean removeFromAsyncHistorySession) {
        Map jobData;
        AsyncHistorySession.AsyncHistorySessionData asyncHistorySessionData;
        Map sessionData = this.getAsyncHistorySession().getSessionData();
        if (sessionData != null && (asyncHistorySessionData = (AsyncHistorySession.AsyncHistorySessionData)sessionData.get(this.getJobServiceConfiguration())) != null && (jobData = asyncHistorySessionData.getJobData()) != null && jobData.containsKey("activity-start")) {
            List activityStartDataList = (List)jobData.get("activity-start");
            Iterator activityStartDataIterator = activityStartDataList.iterator();
            while (activityStartDataIterator.hasNext()) {
                ObjectNode activityStartData = (ObjectNode)activityStartDataIterator.next();
                if (!runtimeActivityInstanceId.equals(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)activityStartData, (String)"runtimeActivityInstanceId"))) continue;
                if (removeFromAsyncHistorySession) {
                    activityStartDataIterator.remove();
                }
                return activityStartData;
            }
        }
        return null;
    }

    protected JobServiceConfiguration getJobServiceConfiguration() {
        return this.getProcessEngineConfiguration().getJobServiceConfiguration();
    }
}

